package HAREM::ClassificacaoMorfologica;

use 5.006;
use strict;
use warnings;
#use Data::Dumper;
use locale;
use HAREM::TagsHash;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw( Avaliar_CMorfologica Estatisticas_ACMorfologica);

our $VERSION = '1.2.2';

my @meses=qw /Janeiro Fevereiro Maro Abril Maio Junho Julho Agosto Setembro Outubro Novembro Dezembro /;

#########################################################################

#Pontuao numrica
our %C = (
	  'Correcto' => '1',
	  'Parcialmente Correcto' => '0.5',
	  'Em Falta' => '0',
	  'Esprio' => '0',
	  'Sobre especificado' => '0',
	  'Parcialmente sobre especificado' => '0',
	  'Incorrecto' => '0',
	  );

sub p{
    my ($a)=@_;
    $a.=' '.$C{$a};
}

################################################################################
# Estatsticas ACM
################################################################################

sub totxt_mor{
    my ($stat)=@_;
    my $r;

    #print Dumper $stat;
    my %a = $stat->getMorphStats;

    my $data= ((gmtime)[3])." de ".@meses[((gmtime)[4])]." de ".(1900+(gmtime)[5]);
    $r.="\tRELATRIO DA AVALIAO DA CLASSIFICAO MORFOLGICA\n";
    $r.="\tGerado em: $data\n\n\n";

    $r.="Avaliao Global da Classificao Morfolgica - Nmero\n\n";
    $r.="Total de classificaes da CD: ".$a{NTSO}."\n";
    $r.="Total de classificaes do sistema : ".$a{NTSU}."\n\n";
    
    my $nc=$a{NCOR}+(0.5*$a{NPCOR});
    my $nse=$a{NSSP}+(0.5*$a{NPSSP});

    if ($a{NTSU}!=0){
	$r.="Preciso: ".($nc/$a{NTSU}) ."\n";
    }else{$r.="Preciso: 0\n";}
    if ($a{NTSO}!=0){
	$r.="Abrangncia: ".($nc/$a{NTSO})."\n";
    }else{$r.="Abrangncia: 0\n";}
    if ($a{NTSO}!=0 && $a{NTSU}!=0 && $nc!=0) { 
	$r.="Medida F: ".(2*($nc/$a{NTSU})*($nc/$a{NTSO}) / ($nc/$a{NTSU}+$nc/$a{NTSO}))."\n";
    }else{$r.="Medida F: 0\n";}
    if ($a{NTSU}!=0){
	$r.="Sobre-especificao: ".($nse/$a{NTSU})."\n";
    }else{$r.="Sobre-especificao: 0\n";}
    if ($a{NTSU}!=0){
	$r.="Sobre-gerao: ".($a{NESP}/$a{NTSU})."\n";
    }else{$r.="Sobre-gerao: 0\n";}
    if ($a{NTSO}!=0){
	$r.="Sub-gerao: ".($a{NEMF}/$a{NTSO})."\n";
    }else{$r.="Sub-gerao: 0\n";}
    #if (($a{NEMF}+$a{NESP}+$nc)!=0){
	#$r.="Erro Combinado: ".($a{NINC}+$a{NEMF}+$a{NESP}+$a{NSSP})/($a{NEMF}+$a{NESP}+$a{NSSP}+$nc)."\n";
    #}else{ $r.="Erro Combinado: 0\n";}
    
    $r.="\n\nAvaliao Global da Classificao Morfolgica - Gnero\n\n";
    $r.="Total de classificaes da CD: ".$a{GTSO}."\n";
    $r.="Total de classificaes do sistema : ".$a{GTSU}."\n\n";

    my $gc=$a{GCOR}+(0.5*$a{GPCOR});
    my $gse=$a{GSSP}+(0.5*$a{GPSSP});

    if ($a{GTSU}!=0){
	$r.="Preciso: ".($gc/$a{GTSU}) ."\n";
    }else{$r.="Preciso: 0\n";}
    if ($a{GTSO}!=0){
	$r.="Abrangncia: ".($gc/$a{GTSO})."\n";
    }else{$r.="Abrangncia: 0\n";}
    if ($a{GTSO}!=0 && $a{GTSU}!=0 && $gc!=0) { 
	$r.="Medida F: ".(2*($gc/$a{GTSU})*($gc/$a{GTSO}) / ($gc/$a{GTSU}+$gc/$a{GTSO}))."\n";
    }else{$r.="Medida F: 0\n";}
    if ($a{GTSU}!=0){
	$r.="Sobre-especificao: ".($gse/$a{GTSU})."\n";
    }else{$r.="Sobre-especificao: 0\n";}
    if ($a{GTSU}!=0){
	$r.="Sobre-gerao: ".($a{GESP}/$a{GTSU})."\n";
    }else{$r.="Sobre-gerao: 0\n";}
    if ($a{GTSO}!=0){
	$r.="Sub-gerao: ".($a{GEMF}/$a{GTSO})."\n";
    }else{$r.="Sub-gerao: 0\n";}
    #if ($a{GEMF}!=0 || $a{GESP}!=0 || $gc!=0){
	#$r.="Erro Combinado: ".($a{GINC}+$a{GEMF}+$a{GESP}+$a{GSSP})/($a{GEMF}+$a{GESP}+$a{GSSP}+$gc)."\n";
    #}else{ $r.="Erro Combinado: 0\n";}

    $r.="\n\nAvaliao Global da Classificao Morfolgica - Combinada\n\n";
    $r.="Total de classificaes da CD: ".$a{CTSO}."\n";
    $r.="Total de classificaes do sistema : ".$a{CTSU}."\n\n";
    
    my $cc=$a{CCOR}+(0.5*$a{CPCOR});

    #print STDERR $a{CCOR}." - ".$a{CTSU}." - ".$a{CINC}."\n";

    if ($a{CTSU}!=0){
	$r.="Preciso: ".($cc/$a{CTSU}) ."\n";
    }else{$r.="Preciso: 0\n";}
    if ($a{CTSO}!=0){
	$r.="Abrangncia: ".($cc/$a{CTSO})."\n";
    }else{$r.="Abrangncia: 0\n";}
    if ($a{CTSO}!=0 && $a{CTSU}!=0 && $cc!=0) { 
	$r.="Medida F: ".(2*($cc/$a{CTSU})*($cc/$a{CTSO}) / ($cc/$a{CTSU}+$cc/$a{CTSO}))."\n";
    }else{$r.="Medida F: 0\n";}

    return $r;
}
#######################################################

sub ler_resultados_vizir{
    my ($e, $F)=@_;

    my $h;
    my $i=0;
    while (<$F>){
	chomp;
	s/<\/?\d+>//g; #Filtrar etiquetas do AlinhEM
	if (/HAREM-/){
	    $h=$_;
	    $i=0;
	}elsif (/^<EM/ || /^<ESPURIO/){
	    my ($morfg, $morfn, $pal, $s);
	    my @cl;
	    if (/<EM MORF=\"(.),(.)\">(.+)<\/EM> ---> \[(.+)\]:\[\((.+)\)\]/){
		#print "$1, $2, $3, $4 ,$5\n";
		($morfg, $morfn, $pal, $s)=($1, $2, $3 ,$4);
		@cl=split /\) \(/, $5;
	    }elsif (/<EM>([^<]+)<\/EM> ---> \[(.+)\]:\[\((.+)\)\]/){
		#print "$1, $2, $3\n";
		($morfg, $morfn, $pal, $s)=('E','E',$1,$2);
		@cl=split /\) \(/, $3;
	    }elsif (/<ESPURIO>(.*)<\/ESPURIO> ---> \[(.+)\]:\[\((.+)\)\]/){
		#print "$1, $2, $3\n";
		($morfg, $morfn, $pal, $s)=('E','E',$1,$2);
		@cl=split /\) \(/, $3;
	    }

	    my @morfgs; my @morfns; my @pals;

	    if ($s=~/<EM MORF=\"(.),(.)\">(.+)<\/EM>/){
		push @morfgs, $1;
		push @morfns, $2;
		push @pals, $3;
	    }elsif ($s=~/<EM>(.+)<\/EM>/){
		push @morfgs, 'null';
		push @morfns, 'null';
		push @pals, $1;
	    }elsif ($s=~/^null$/){
		push @morfgs, 'null';
		push @morfns, 'null';
		push @pals, 'null';
	    }else{
		warn "linha no reconhecida desconhecida(1):$. : $_\n";
	    }
	    
	    $e->{$h}[$i]={ morfg => $morfg,
			   morfn => $morfn, 
			   pal => "$pal", 
			   morfgs => [@morfgs],
			   morfns => [@morfns],
			   pals => [@pals], 
		       };
	    
	    foreach (@cl){
		my ($k,$v)=split /\: /, $_;
		$v=~s/ [\.\d]+//;
		$e->{$h}[$i]{$k}=$v;
	    }
	    $i++;
	}else{
	    next if (/^\s*$/);
	    warn "linha no reconhecida(2):$. : $_\n";
	}
    }
}




###########################################

sub debug {
    my ($D, $a, $stat)=@_;

    my %z = $stat->getMorphStats ('EM');

    #rebuild pair
    my $t='';
    
    if ($a->{morfg} eq 'E'){
	$t= '<ESPURIO>'.$a->{pal}.'</ESPURIO> ---> [';
    }else{
	$t= '<EM MORF="'.$a->{morfg}.','.$a->{morfn}.'">'.$a->{pal}.'</EM> ---> [';
    }
    for (my $x=0; $x<=$#{$a->{pals}}; $x++){
	if ($a->{morfgs}[$x] eq 'null'){
	    if ($a->{pals} eq 'null'){
		$t.= 'null';
	    }else{
		$t.= '<EM>'.$a->{pals}[$x].'</EM>';
		$t.= ', ' if ($x<$#{$a->{pals}});
	    }
	}else{
	    $t.= '<EM MORF="'.$a->{morfgs}[$x].','.$a->{morfns}[$x].'">'.$a->{pals}[$x].'</EM>';
	    $t.= ', ' if ($x<$#{$a->{pals}});
	}
    }
    $a->{'Gnero'}=~s/ \- Sistema//;
    $a->{'Nmero'}=~s/ \- Sistema//;
    $t.= ']:['.&retornar ($a->{'Gnero'},$a->{'Nmero'},$a->{'Combinada'})."]\n\n";
    
    $t.= '--- Somatrio da pontuao ---'."\n";
    $t.= "----------------- Nmero -- Gnero -- Combinada\n\n";
    $t.= 'Nmero de EMs da CD : '. $z{NTSO} .' -- '. $z{GTSO} .' -- '. $z{CTSO}."\n";
    $t.= 'N. EMs Subm. sistema: '. $z{NTSU} .' -- '. $z{GTSU} .' -- '. $z{CTSU}."\n";
    $t.= 'N. EMs Correctas    : '. $z{NCOR} .' -- '. $z{GCOR} .' -- '. $z{CCOR}."\n";
    $t.= 'N. EMs P. Correctas : '. $z{NPCOR} .' -- '. $z{GPCOR} .' -- '. $z{CPCOR}."\n";
    $t.= 'N. EMs Incorrectas  : '. $z{NINC} .' -- '. $z{GINC} .' -- '. $z{CINC}."\n";
    $t.= 'N. EMs Sobre especif: '. $z{NSSP} .' -- '. $z{GSSP} ."\n";
    $t.= 'N. EMs P. Sobre espe: '. $z{NPSSP} .' -- '. $z{GPSSP} ."\n";
    $t.= 'N. EMs em Falta     : '. $z{NEMF} .' -- '. $z{GEMF} ."\n";
    $t.= 'N. EMs Esprio      : '. $z{NESP} .' -- '. $z{GESP} ."\n\n\n";

    print $D $t;
}

###########################################

sub contabilizar_acm{
    my ($D, $acm, $stat)=@_;

    foreach my $h (keys %{$acm}){
	foreach my $a (@{$acm->{$h}}){
	    #print Dumper ($a);
	    ##################### Considerar EM="F,S" --> EM="?,?" para o total de EMs de sistema
	    $a->{'Gnero'}='Em Falta - Sistema' if ($a->{morfg}=~/[FM]/ && @{$a->{morfgs}}[0] eq '?' && $a->{'Gnero'} eq "Em Falta");
	    $a->{'Nmero'}='Em Falta - Sistema' if ($a->{morfn}=~/[SP]/ && @{$a->{morfns}}[0] eq '?' && $a->{'Nmero'} eq "Em Falta");
	    #####################
	    $stat->setMorphClassification($a->{'Gnero'},$a->{'Nmero'},$a->{'Combinada'});
	    &debug ($D, $a, $stat) if ($D!=0);
	}
    }
}

######################################

sub relatorio_acm{
    my $G=shift;
    print $G &totxt_mor(@_);
}

########################################

#sub ajustar_resultado{
#    my ($fi, $stat, $t)=@_;
#    $fi=~s~.+/([^\/]+)$~$1~; #retirar path
#
#    #print STDERR Dumper $fi;
#    #print STDERR Dumper $t;

#    foreach my $f (@{$t}){
#	if (defined($f->{inicio_nome_ficheiro})){
#	    my $a=$f->{inicio_nome_ficheiro};
#	    if ($fi=~/^\Q$a\E/i){
#		if (defined($f->{fim_nome_ficheiro})){
#		    $a=$f->{fim_nome_ficheiro};
#		    next if ($fi!~/\Q$a\E$/i);
#		}
#		foreach (keys %{$f}){
#		    next if (/ficheiro/i);
#		    $stat->adjMorphClassification($_, $f->{$_});
#		    print STDERR "Modificao $fi : $_ -- ".$f->{$_}."\n";
#		}
#	    }
#	}
#    }
#}		    


#######################################

sub Estatisticas_ACMorfologica{
    my ($F,$G,$D, $t)=@_;
    my %acm;
    #my $csc; my $csc_cd; my $csc_sist;

    &ler_resultados_vizir(\%acm, $F); #contabilizar numero EM na CD e submetidas

    my $stat = new HAREM::TagsHash();

    &contabilizar_acm ($D, \%acm, $stat);

    #print Dumper \%acm;
    #print Dumper $stat;
    #&ajustar_resultado($F, $stat, $t);

    &relatorio_acm($G, $stat);
}

################################################################################
# Avaliar Classificao Morfolgica
###############################################################################

sub retornar{
    my ($genero, $numero, $combinada)=@_;
    my $t='(Gnero: '.&p($genero).')';
    $t.=' (Nmero: '.&p($numero).')';
    $t.=' (Combinada: '.&p($combinada).')';

    return $t;
}

##############################

sub avaliar_alinhamento_classificacao_morfologica{
    my ($genero, $numero, $sgenero, $snumero, $pal, $pals)=@_;

    $pal=lc($pal);
    $pals=lc($pals);

    my $morfg; my $morfn; my $morfc;
    
    #GENERO
    if ($genero eq $sgenero){
	if ($pal eq $pals){
	    $morfg='Correcto';
	}else{
	    $morfg='Parcialmente Correcto';
	}
    }elsif ($sgenero eq '?'){
	$morfg='Em Falta'; 
    }elsif ($genero eq '?'){
	if ($pal eq $pals){
	    $morfg='Sobre especificado';
	}else{
	    $morfg='Parcialmente sobre especificado';
	}
    }else{
	$morfg='Incorrecto';
    }
    
    #Nmero
    if ($numero eq $snumero){
	if ($pal eq $pals){
	    $morfn='Correcto';
	}else{
	    $morfn='Parcialmente Correcto';
	}
    }elsif ($snumero eq '?'){
	$morfn='Em Falta';
    }elsif ($numero eq '?'){
	if ($pal eq $pals){
	    $morfn='Sobre especificado';
	}else{
	    $morfn='Parcialmente sobre especificado';
	}
    }else{
	$morfn='Incorrecto';
    }
    
    #Combinada
    if ($morfg eq 'Incorrecto' || $morfn eq 'Incorrecto' || $morfg eq 'Sobre especificado' || $morfn eq 'Sobre especificado' || $morfg eq 'Parcialmente sobre especificado' || $morfn eq 'Parcialmente sobre especificado'){
	$morfc='Incorrecto';
    }elsif($morfg eq 'Em Falta' || $morfn eq 'Em Falta'){
	$morfc='Em Falta';
    }else{
	if ($pal eq $pals){
	    $morfc='Correcto';
	}else{
	    $morfc='Parcialmente Correcto';
	}
    }
    
    return ($morfg, $morfn, $morfc);
}

##########################################################

#  Efectua a avaliao morfolgica para cada alinhamento

sub Avaliar_CMorfologica{       
    my ($p)=@_;

    my $genero='';
    my $numero='';
    my $sgenero='';
    my $snumero='';
    my $pal;
    my $spal;
    my $id;
    my $csc;

    my $morfg;
    my $morfn;
    my $morfc;

    my $a; my $b;
    
    if ($p=~/^(.+) ---> \[(.+)\]:\[(.+)\]$/){
	$a=$1;
	$b=$2;
	$id=$3;

	if ($a=~/<EM ?(.+)?>(.*)<\/.+>/){
	    $pal=$2;
	    my $d=$1;
	    
	    if (defined ($d) && ($d=~/MORF=\"([MF\?]),([SP\?])\"/)){
		$genero=$1;
		$numero=$2;
	    }else{
		return '';
	    }
	}elsif ($a=~/<ESPURIO>(.*)<\/ESPURIO>/){
	    if ($b=~/MORF=/){
		unless ($b=~/MORF=\"([MF\?],[SP\?])\"/ && $1=~/\?,\?/){ #apenas a primeira EM classificada que encontra.
		    return &retornar ('Esprio','Esprio','Esprio');
		}
	    }
	    return '';
	}else{
	    die "(1) Formato inesperado $a\n";
	}

	my $t='';
	foreach (split />, /,$b){  #para cada combinao da EM do sistema
	    $_.='>' if (substr($_,length($_)-1,1) ne '>'  && !/null/);
	    if (/<EM ?(.+)?>(.*)<\/.+>/){
		$spal=$2;
	        my $d=$1;
		if (defined ($d) && ($d=~/MORF\=\"([MF\?]),([SP\?])\"/)){
		    $sgenero=$1;
		    $snumero=$2;
		}else{
		    $morfg='Em Falta'; $morfn='Em Falta'; $morfc='Em Falta';
		    $t=retornar ($morfg,$morfn,$morfc);
		    next;
		}
	    }elsif (/^null$/){       # EM do sistema sem classificao
		return &retornar ('Em Falta','Em Falta','Em Falta');
	    }else{
		die "(2) Formato inesperado: $_\n";
	    }
	
	    $pal=~s/(\w\-)\s(\w)/$1$2/; #fix
	    $pal=~s/\W+$//; #fix [,"$]
	    $spal=~s/\W+$//;

	    my @p1=split / /,$pal;
	    my @p2=split / /,$spal;
	    my ($p1,$p2)=(shift @p1, shift @p2); #Verificar se o primeiro tomo da EM coincide
	    $p1=~s/[\,\(\)]//g; #Fixs
	    $p2=~s/[\,\(\)]//g; 
	    
	    if ($p1=~/^$p2$/i){
		($morfg, $morfn, $morfc)=&avaliar_alinhamento_classificacao_morfologica($genero,$numero,$sgenero,$snumero,$pal,$spal);
		$t=retornar ($morfg,$morfn,$morfc);
	        last if ($t=~/correcto/i);
	    }else{
		$morfg='Em Falta'; $morfn='Em Falta'; $morfc='Em Falta';
		$t=retornar ($morfg,$morfn,$morfc);
	    }
	    
	}
	return &retornar ('Esprio','Esprio','Esprio') unless ($a=~/MORF=/);
	#$t=~s/, $//;
	return $t;
    }else{
	warn "formato inesperado(3): $p\n";
    }
}

###########################################

1;
    
__END__

=head1 NAME

HAREM::ClassificacaoMorfologica - HAREM Morphology Classification Evaluation module for perl

=head1 SYNOPSIS

use HAREM::ClassificacaoMorfologica;

@p=[
    '<EM MORF="F,S">Joana</EM> ---> [<EM MORF="M,S">Joana</EM>]:[Correcto]',
    '<EM MORF="M,S">Joo</EM> ---> [<EM MORF="F,S">Ditadura de Joo Franco</EM>]:[Parcialmente_Correcto_por_Excesso(0.25; 0.75)]',
    '<ESPURIO>Guerra</ESPURIO> ---> [<EM MORF="F,S">Guerra</EM>]:[Esprio]',
    '<EM MORF="M,S">Ministro dos Negcios Estrangeiros</EM> ---> [null]:[Em_Falta]'
    ];

&Avaliar_CMorfologica($p) foreach (@p); # Generates results of the assesment of the classification

--------------------------------------
    
#Results depends on the schema used for evaluation, See HAREM documentation for more information
    
@m=[
    '<EM MORF="F,S">Joana</EM> ---> [<EM MORF="M,S">Joana</EM>]:[(Gnero: Incorrecto 0) (Nmero: Correcto 0) (Combinada: Incorrecto 0)]',
    '<EM MORF="M,S">Joo</EM> ---> [<EM MORF="F,S">Ditadura de Joo Franco</EM>]:[(Gnero: Em Falta 0) (Nmero: Em Falta 0) (Combinada: Em Falta 0)]',
    '<ESPURIO>Guerra</ESPURIO> ---> [<EM MORF="F,S">Guerra</EM>]:[(Gnero: Esprio 0) (Nmero: Esprio 0) (Combinada: Esprio 0)]',
    '<EM MORF="M,S">Ministro dos Negcios Estrangeiros</EM> ---> [null]:[(Gnero: Em Falta 0) (Nmero: Em Falta 0) (Combinada: Em Falta 0)]',
];

&Estatisticas_ACMorfologica($m) foreach ($m); #Generates individual statistics

=head1 DESCRIPTION

Module for evaluation of an aligment of named entities with morphologic classification

=head2 Avaliar_CMorfologica

Allows to make an assesment of a named entity aligment.

=head2 Estatisticas_ACMorfologica

Allows to make a statistical assesment of the previous results

=back

=head1 SEE ALSO

HAREM/TagsHash.pm

perl(1)

http://poloxldb.linguateca.pt/harem.php

=head1 AUTHOR

Rui Vilela (ruivilela@di.uminho.pt)

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2005 by Linguateca (http://www.linguateca.pt)

(EN)
This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.5 or,
at your option, any later version of Perl 5 you may have available.

(PT)
Esta biblioteca  software de domnio pblico; pode redistribuir e/ou
modificar este mdulo nos mesmos termos do prprio Perl, quer seja a
verso 5.8.5 ou, na sua liberdade, qualquer outra verso do Perl 5 que
tenha disponvel.

=cut



