package HAREM::TagsHash;

#use strict;
use locale;
#use Data::Dumper;

sub new {
   my $class = shift;
   my $maintags= {"GENEROCORRECTO"=>0,
		  "GENEROPCORRECTO"=>0,
		  "GENEROINCORRECTO"=>0,
		  "GENEROEMFALTA"=>0,
		  "GENEROESPURIO"=>0,
		  "GENEROSOBREESPECIFICADO"=>0,
		  "GENEROPSOBREESPECIFICADO"=>0,
		  "NUMEROCORRECTO"=>0,
		  "NUMEROPCORRECTO"=>0,
		  "NUMEROINCORRECTO"=>0,
		  "NUMEROEMFALTA"=>0,
		  "NUMEROESPURIO"=>0,
		  "NUMEROSOBREESPECIFICADO"=>0,
		  "NUMEROPSOBREESPECIFICADO"=>0,		      
		  "COMBINADACORRECTO"=>0,
		  "COMBINADAPCORRECTO"=>0,
		  "COMBINADAINCORRECTO"=>0,
		  "COMBINADAEMFALTA"=>0,
		  "COMBINADAESPURIO"=>0,
		  "NUMEROSISTEMA_PLUS"=>0,
		  "GENEROSISTEMA_PLUS"=>0,
		  "COMBINADASISTEMA_PLUS"=>0,
		  };
   bless ($maintags, $class);
   return $maintags;
}

sub adjMorphClassification { #Adjusting parameters
    my ($theclass,$what, $many) = @_;
  
    if ($what eq "Correcto") {
	$theclass->{GENEROCORRECTO}+=$many;
	$theclass->{NUMEROCORRECTO}+=$many;
	$theclass->{COMBINADACORRECTO}+=$many;
    }
    
    if ($what eq "Incorrecto") {
	$theclass->{GENEROINCORRECTO}+=$many;
	$theclass->{NUMEROINCORRECTO}+=$many;
	$theclass->{COMBINADAINCORRECTO}+=$many;
    }
}


sub setMorphClassification {
    my ($theclass,$whatGen,$whatNum,$whatComb) = @_;
  
    if ($whatGen eq "Em Falta - Sistema" && $whatNum eq "Em Falta - Sistema") { #Apenas ambos contam
	$theclass->{COMBINADASISTEMA_PLUS}++;
    }

    if ($whatGen eq "Em Falta - Sistema") {
	$theclass->{GENEROSISTEMA_PLUS}++;
	$whatGen="Em Falta";
    } #Casos para as EM="F,S"-->EM="?,?"

    if ($whatNum eq "Em Falta - Sistema") {
	$theclass->{NUMEROSISTEMA_PLUS}++;
	$whatNum="Em Falta";
    } #Casos para as EM="F,S"-->EM="?,?"

    if ($whatGen eq "Correcto") {$theclass->{GENEROCORRECTO}++;}
    elsif ($whatGen eq "Incorrecto") {$theclass->{GENEROINCORRECTO}++;}
    elsif ($whatGen eq "Em Falta") {$theclass->{GENEROEMFALTA}++;}
    elsif ($whatGen eq "Esprio") {$theclass->{GENEROESPURIO}++;}
    elsif ($whatGen eq "Sobre especificado") {$theclass->{GENEROSOBREESPECIFICADO}++;}
    elsif ($whatGen eq "Parcialmente sobre especificado") {$theclass->{GENEROPSOBREESPECIFICADO}++;}
    elsif ($whatGen eq "Parcialmente Correcto") {$theclass->{GENEROPCORRECTO}++;}

    if ($whatNum eq "Correcto") {$theclass->{NUMEROCORRECTO}++;}
    elsif ($whatNum eq "Incorrecto") {$theclass->{NUMEROINCORRECTO}++;}
    elsif ($whatNum eq "Em Falta") {$theclass->{NUMEROEMFALTA}++;}
    elsif ($whatNum eq "Esprio") {$theclass->{NUMEROESPURIO}++;}
    elsif ($whatNum eq "Sobre especificado") {$theclass->{NUMEROSOBREESPECIFICADO}++;}
    elsif ($whatNum eq "Parcialmente sobre especificado") {$theclass->{NUMEROPSOBREESPECIFICADO}++;}
    elsif ($whatNum eq "Parcialmente Correcto") {$theclass->{NUMEROPCORRECTO}++;}

    $whatComb="Incorrecto" if ($whatComb eq "Em Falta" && ($whatNum ne "Em Falta" || $whatGen ne "Em Falta")); #PATCH (Est Em Falta, mas foi submetida parte da classificao morfolgica)

    if ($whatComb eq "Correcto") {$theclass->{COMBINADACORRECTO}++;}
    elsif ($whatComb eq "Incorrecto") {$theclass->{COMBINADAINCORRECTO}++;}
    elsif ($whatComb eq "Em Falta") {$theclass->{COMBINADAEMFALTA}++;}
    elsif ($whatComb eq "Esprio") {$theclass->{COMBINADAESPURIO}++;}
    elsif ($whatComb eq "Parcialmente Correcto") {$theclass->{COMBINADAPCORRECTO}++;}
}

sub getMorphStats {
    my ($theclass) = @_;

    $gcorr = $theclass->{GENEROCORRECTO};
    $gpcorr = $theclass->{GENEROPCORRECTO};
    $gincorr = $theclass->{GENEROINCORRECTO};
    $gmiss = $theclass->{GENEROEMFALTA};
    $gspur = $theclass->{GENEROESPURIO};
    $gsesp = $theclass->{GENEROSOBREESPECIFICADO};
    $gpsesp = $theclass->{GENEROPSOBREESPECIFICADO};
    $gsplus = $theclass->{GENEROSISTEMA_PLUS};

    $gtotalsol = $gcorr+$gpcorr+$gincorr+$gmiss+$gsesp+$gpsesp;
    #print "$gtotalsol = $gcorr + $gpcorr + $gincorr + $gmiss / $gspur\n";
    $gtotalsub = $gcorr+$gpcorr+$gincorr+$gspur+$gsesp+$gpsesp+$gsplus;

    $ncorr = $theclass->{NUMEROCORRECTO};
    $npcorr = $theclass->{NUMEROPCORRECTO};
    $nincorr = $theclass->{NUMEROINCORRECTO};
    $nmiss = $theclass->{NUMEROEMFALTA};
    $nspur = $theclass->{NUMEROESPURIO};
    $nsesp = $theclass->{NUMEROSOBREESPECIFICADO};
    $npsesp = $theclass->{NUMEROPSOBREESPECIFICADO};
    $nsplus = $theclass->{NUMEROSISTEMA_PLUS};

    $ntotalsol = $ncorr+$npcorr+$nincorr+$nmiss+$nsesp+$npsesp;
    #print "$ntotalsol = $ncorr + $npcorr + $nincorr + $nmiss / $nspur\n";
    $ntotalsub = $ncorr+$npcorr+$nincorr+$nspur+$nsesp+$npsesp+$nsplus;

    $ccorr = $theclass->{COMBINADACORRECTO};
    $cpcorr = $theclass->{COMBINADAPCORRECTO};
    $cincorr = $theclass->{COMBINADAINCORRECTO};
    $cmiss = $theclass->{COMBINADAEMFALTA};
    $cspur = $theclass->{COMBINADAESPURIO};
    $csplus = $theclass->{COMBINADASISTEMA_PLUS};

    $ctotalsol = $ccorr+$cpcorr+$cincorr+$cmiss;
    $ctotalsub = $ccorr+$cpcorr+$cincorr+$cspur+$csplus;

     return ("GTSO"=>$gtotalsol,"GTSU"=>$gtotalsub,"GCOR"=>$gcorr, "GPCOR"=>$gpcorr, 
	     "GINC"=>$gincorr,"GEMF"=>$gmiss,"GESP"=>$gspur,"GSSP"=>$gsesp,"GPSSP"=>$gpsesp,

	     "NTSO"=>$ntotalsol,"NTSU"=>$ntotalsub,"NCOR"=>$ncorr, "NPCOR"=>$npcorr,
	     "NINC"=>$nincorr,"NEMF"=>$nmiss,"NESP"=>$nspur,"NSSP"=>$nsesp,"NPSSP"=>$npsesp,

	     "CTSO"=>$ctotalsol,"CTSU"=>$ctotalsub,"CCOR"=>$ccorr, "CPCOR"=>$cpcorr,
	     "CINC"=>$cincorr,"CEMF"=>$cmiss,"CESP"=>$cspur,
		 );

}

sub gethash {
    ($theclass)=@_;
    return $theclass;
}

1;

__END__


=head1 NAME

HAREM::TagsHash - Perl module for accounting morphologic information

=head1 SYNOPSIS

  use HAREM::TagsHash;

=head1 DESCRIPTION

Support for Module ClassificacaoMorfologica.pm.

=head2 EXPORT

None by default.

=head1 SEE ALSO

HAREM/ClassificacaoMorfologica.pm

http://poloxldb.linguateca.pt/harem.php

=head1 AUTHOR

Nuno Cardoso, E<lt>ncardoso@localdomainE<gt>
Rui Vilela, <lt>ncardoso@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2004,2005 Linguateca

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.3 or,
at your option, any later version of Perl 5 you may have available.


=cut
