#!/usr/bin/perl

# AVISO: ESTE PROGRAMA TEM DE CORRER EM ISO-8859-1!!! Fazer export LANG=pt_PT ANTES!

# Este programa pega nos resultados gerados pelos programas ida2id, ida2mor
# e ida2sem, mais os relatrios gerados pelo Sulto, e cria relatrios individuais
# em HTML. 

use locale;
use Getopt::Long;
use Math::BigFloat;
use GD;
use GD::Graph::bars;
use GD::Graph::points;

### Variveis globais 

my $chave; # a chave para a desanonimizao
my $runs;  # O nome da sada
my $sistema; # O nome do sistema
my $current_task; # nome da tarefa a ser executada
my $contador = 0; # contador, para gerao de nomes de imagens

### Variveis de configurao da apresentao de tabelas

# nmero de itens a apersentar. De reparar que na morfologia, h duas categorias que
# no tem anlise morfolgica
%number_of_itens = ("categoria" => 9, "gnero textual" => 8, "variante" => 2);
%number_of_morf_itens = ("categoria" => 7, "gnero textual" => 8, "variante" => 2);

# nomes / ttulos / configuraes de tabelas
my @morf_tables=("combinada","nmero","gnero");
my @morf_tables_size=("small","large","large");
my @sem_abs_tables=("combinada","plana","por categorias");
my @sem_rel_tables=("combinada","plana","por categorias","por tipos");
my @sem_table_abs_size=("small","large","large");
my @sem_table_rel_size=("small","large","large","large");

# nomes das categorias / gneros textuais / variantes (Nota: nomes a ler dos ficheiros)
my @categoria=("pessoa","organizacao","tempo","local","obra","acontecimento","abstraccao","coisa","valor");
my @categoria_morf=("pessoa","organizacao","local","obra","acontecimento","abstraccao","coisa");
my @genero=("jornalstico","literrio","expositivo","poltico","web","entrevista","correioelectrnico","tcnico");
my @variante=("pt","br");

# converso de nomes a ler, em nomes a escrever
my %pretty_print=("pessoa"=>"PESSOA","organizacao"=>"ORGANIZACAO","tempo"=>"TEMPO","local"=>"LOCAL","obra"=>"OBRA",
		 "acontecimento"=>"ACONTECIMENTO","abstraccao"=>"ABSTRACCAO","coisa"=>"COISA","valor"=>"VALOR",
		 "jornalstico"=>"Jornalstico","literrio"=>"Literrio","expositivo"=>"Expositivo",
		  "poltico"=>"Poltico","web"=>"Web","entrevista"=>"Entrevista",
		  "correioelectrnico"=>"Correio El.","tcnico"=>"Tcnico","pt"=>"Lusa","br"=>"Brasileira");

# Cores para os grficos:Vermelho, verde, azul, magenta, cinza, cyan, laranja, indigo ,violeta, castanho,
# verde escuro, rosa, cinza escuro, amarelo escuro, verde-azul, roxo, rosa claro, laranja torrado,
# verde clarinho azul escuro, azul claro, laranja bao, vinho,rose choque,azul mdio, beje
my @red = (255,0,0,255,192,0,255,204,138,128,52,255,64,137,42,121,245,153,163,16,159,255,126,255,52,183);
my @green= (0,255,0,0,192,255,192,255,0,0,104,128,64,144,209,77,161,101,255,10,238,170,41,18,114,159);
my @blue= (0,0,255,255,192,255,0,0,255,0,0,255,64,62,124,134,255,0,161,76,255,136,67,90,183,130);
my @color_hex=("ff0000","00ff00","0000ff","ff00ff","c0c0c0","00ffff","ffc000","ccff00","8a00ff",
	       "800000","346800","ff88ff","404040","89903e","2ad17c","794d86","f5a1ff","996500",
	       "a3ffa1","100a4c","9feeff","ffaa88","7e2943","ff125a","3472b7","b79f82");


# ficheiros Sulto a ler (identificao) 
my @identificacao_files=("identificacao_total_oficiais.html","identificacao_selectivo_oficiais.html",
	 "identificacao_categoria_total_oficiais.html","identificacao_categoria_selectivo_oficiais.html",
       	 "identificacao_genero_total_oficiais.html","identificacao_genero_selectivo_oficiais.html",
       	 "identificacao_variante_total_oficiais.html","identificacao_variante_selectivo_oficiais.html");

# ficheiros Sulto a ler (morfologia)
my @morfologia_files=("morfologia_total_oficiais_absolutos.html","morfologia_selectivos_oficiais_absolutos.html",
"morfologia_total_oficiais_relativos.html","morfologia_selectivos_oficiais_relativos.html",
"morfologia_categoria_total_oficiais_absolutos.html","morfologia_categoria_selectivo_oficiais_absolutos.html",
"morfologia_categoria_total_oficiais_relativos.html","morfologia_categoria_selectivo_oficiais_relativos.html",
"morfologia_genero_total_oficiais_absolutos.html","morfologia_genero_selectivo_oficiais_absolutos.html",
"morfologia_genero_total_oficiais_relativos.html","morfologia_genero_selectivo_oficiais_relativos.html",
"morfologia_variante_total_oficiais_absolutos.html","morfologia_variante_selectivo_oficiais_absolutos.html",
"morfologia_variante_total_oficiais_relativos.html","morfologia_variante_selectivo_oficiais_relativos.html");

# ficheiros Sulto a ler (semntica)
my @semantica_files=("semantica_total_oficiais_absolutos.html","semantica_selectivo_oficiais_absolutos.html",
"semantica_total_oficiais_relativos.html","semantica_selectivo_oficiais_relativos.html",
"semantica_categoria_total_oficiais_absolutos.html","semantica_categoria_selectivo_oficiais_absolutos.html",
"semantica_categoria_total_oficiais_relativos.html","semantica_categoria_selectivo_oficiais_relativos.html",
"semantica_genero_total_oficiais_absolutos.html","semantica_genero_selectivo_oficiais_absolutos.html",
"semantica_genero_total_oficiais_relativos.html","semantica_genero_selectivo_oficiais_relativos.html",
"semantica_variante_total_oficiais_absolutos.html","semantica_variante_selectivo_oficiais_absolutos.html",
"semantica_variante_total_oficiais_relativos.html","semantica_variante_selectivo_oficiais_relativos.html");

### Controlo do programa

my $caption=""; # categoria / gnero / variante da qual pertence uma tabela que se est a ler

# Para debug
my $file_verbose = 0;
my $image_verbose = 0;
my $data_verbose = 0;

# Tarefas a processar
my $arg_id; 
my $arg_morf;
my $arg_sem;

# Numerao de captulos
my $chapter=1;

# Leitura de argumentos
$result = GetOptions ("sistema:s" => \$sistema, "saida:s" => \$runs, "id:i" => \$arg_id, "morf:i" => \$arg_morf, "sem:i" => \$arg_sem);
if (!$result) {
    print "Uso: ./alcaide.pl -sistema [sistema] -saida [saida] -id [0|1] -morf [0|1] -sem [0|1]\n";
    exit(0);
}

if (length($runs)==0) {
    print "Erro: No h sadas para processar.\n";
    exit(0);
} else { 
     print "Sistema: $sistema. Sada: $runs (".ucfirst($runs).")...\n";
}

# Directorias onde esto os ficheiros a processar (ids2id, ids2mor,ida2sem e sulto)
my $directoria_identificacao="./$runs/";
my $directoria_morfologia="./$runs/";
my $directoria_semantica="./$runs/";
my $directoria_ida="./$runs/";

if ($arg_id) {$do_identificacao = "true";}
if ($arg_morf) {$do_morfologia = "true";}
if ($arg_sem) {$do_semantica = "true";}

# ver se h directoria de imagens
if(!-e "imagens/") {
    $rv = system("mkdir imagens");
    if($rv != 0) {
	die ("Erro: no consegui criar directoria imagens/. Erro #".$rv."\n");
    }
}

### RELATRIO - ABERTURA
    open(OUT, ">".$runs."_relatorio.html") || die ("No consegui abrir ficheiro de escrita $runs_relatorio.html");
    $current_task="identificao";$curr_task="identificacao";
    &html_header();
    #&index();

###############################
### Tarefa de Identificao ###
###############################

if ($do_identificacao eq "true") {

### Identificao Resultados Globais

    print OUT "<H3><a name=\"$chapter\">$chapter. Tarefa de $current_task</h3>\n";
    print OUT "<H4><a name=\"$chapter.1\">$chapter.1 Resultados globais</H4>\n";

    $filename = &getFilenameString($runs,"identificacao","","total","");
    &do_simple_identification_table("<H5><a name=\"$chapter.1.1\">$chapter.1.1 Cenrio total </H5>\n",$filename,"bar,xyrun"); 
    $filename = &getFilenameString($runs,"identificacao","","selectivo","");
    &do_simple_identification_table("<H5><a name=\"$chapter.1.2\">$chapter.1.2 Cenrio selectivo </H5>\n",$filename,"bar,xyrun");

### Identificao Resultados Por categorias

    print OUT "<H4><a name=\"$chapter.2\">$chapter.2 Resultados por categorias</H4>\n";
    print OUT "<H5><a name=\"$chapter.2.1\">$chapter.2.1 Cenrio total</H5>\n";

    &do_stat_identification_table("categoria",$runs,"identificacao","total");
    &do_complex_identification_table("categoria","xycat","Identificao. Cenrio total.\nResultado por categorias.");

    print OUT "<H5><a name=\"$chapter.2.2\">$chapter.2.2 Cenrio selectivo </H5>\n";
    &do_stat_identification_table("categoria",$runs,"identificacao","selectivo");
    &do_complex_identification_table("categoria","xycat","Identificao. Cenrio selectivo.\nResultado por categorias.");


### Identificao Resultados por gnero

    print OUT "<H4><a name=\"$chapter.3\">$chapter.3 Resultados por gnero textual</H4>\n"; 
    print OUT "<H5><a name=\"$chapter.3.1\">$chapter.3.1 Cenrio total </H5>\n";
    &do_stat_identification_table("gnero textual",$runs,"identificacao","total");
    &do_complex_identification_table("gnero textual","xycat","Identificao. Cenrio total.\nResultado por gnero textual.");

    print OUT "<H5><a name=\"$chapter.3.2\">$chapter.3.2 Cenrio selectivo </H5>\n";
    &do_stat_identification_table("gnero textual",$runs,"identificacao","total");
    &do_complex_identification_table("gnero textual","xycat","Identificao. Cenrio selectivo.\nResultado por gnero textual.");

### Identificao Resultados por variante
    
    print OUT "<H4><a name=\"$chapter.4\">$chapter.4 Resultados por variante</H4>\n";
    print OUT "<H5><a name=\"$chapter.4.1\">$chapter.4.1 Cenrio total </H5>\n";
    &do_stat_identification_table("variante",$runs,"identificacao","total");
    &do_complex_identification_table("variante","xycat","Identificao. Cenrio total.\nResultado por variante.");
     print OUT "<H5><a name=\"$chapter.4.2\">$chapter.4.2 Cenrio selectivo </H5>\n";
    &do_stat_identification_table("variante",$runs,"identificacao","total");
    &do_complex_identification_table("variante","xycat","Identificao. Cenrio selectivo.\nResultado por variante.");
    &breakpage;   
}

###############################
### Tarefa de Morfologia    ###
###############################

if ($do_morfologia eq "true") {
    $chapter++;    $current_task="classificao morfolgica";$curr_task="morfologia";

### Morfologia Resultados Globais
    print OUT "<H3><a name=\"$chapter\">$chapter. Tarefa de $current_task</h3>\n";   
    print OUT "<H4><a name=\"$chapter.1\">$chapter.1 Resultados globais</H4>\n";
    
### Morfologia Forma de avaliao Absoluta
    
    print OUT "<H4><a name=\"$chapter.1.1\">$chapter.1.1 Forma de avaliao absoluta</H4>\n";
    
    $filename = &getFilenameString($runs,"morfologia","absoluto","total","");
    &do_simple_morphological_table("<H5><a name=\"$chapter.1.1.1\">$chapter.1.1.1 Cenrio total </H5>\n","absoluto",$filename,"bar,xyrun");

    $filename = &getFilenameString($runs,"morfologia","absoluto","selectivo","");
    &do_simple_morphological_table("<H5><a name=\"$chapter.1.1.2\">$chapter.1.1.2 Cenrio selectivo </H5>\n","absoluto",$filename,"bar,xyrun");

    
### Morfologia Forma de avaliao Relativa
    
    print OUT "<H4>$chapter.1.2 Forma de avaliao relativa</H4>\n";
    
    $filename = &getFilenameString($runs,"morfologia","relativo","total","");
    &do_simple_morphological_table("<H5><a name=\"$chapter.1.2.1\">$chapter.1.2.1 Cenrio total </H5>\n","relativo",$filename,"bar,xyrun");

    $filename = &getFilenameString($runs,"morfologia","relativo","selectivo","");
    &do_simple_morphological_table("<H5><a name=\"$chapter.1.2.2\">$chapter.1.2.2 Cenrio selectivo </H5>\n","relativo",$filename,"bar,xyrun");

### Morfologia Resultados por categorias
    
    print OUT "<H4><a name=\"$chapter.2\">$chapter.2 Resultados por categorias</H4>\n"; 
    
### Morfologia Resultados por categorias Forma de avaliao Absoluta
    
    print OUT "<H4><a name=\"$chapter.2.1\">$chapter.2.1 Forma de avaliao absoluta</H4>\n";
    print OUT "<H5><a name=\"$chapter.2.1.1\">$chapter.2.1.1 Cenrio total </H5>\n";
    @tab1 = &do_stat_morphological_table("categoria",$runs,"morfologia","total","absoluto");
    @tab2 = &do_complex_morphological_table("categoria","xycat","Class. morfolgica. Forma absoluta,\nCenrio total, por categorias.");
    &print_morf_tables(@tab1,@tab2);

    print OUT "<H5><a name=\"$chapter.2.1.2\">$chapter.2.1.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_morphological_table("categoria",$runs,"morfologia","selectivo","absoluto");
    @tab2 = &do_complex_morphological_table("categoria","xycat","Class. morfolgica. Forma absoluta,\nCenrio selectivo, por categorias.");
    &print_morf_tables(@tab1,@tab2);

### Morfologia Resultados por categorias Forma de avaliao Relativa
    
    print OUT "<H4><a name=\"$chapter.2.2\">$chapter.2.2 Forma de avaliao relativa</H4>\n";
    print OUT "<H5><a name=\"$chapter.2.2.1\">$chapter.2.2.1 Cenrio total </H5>\n";    
    @tab1 = &do_stat_morphological_table("categoria",$runs,"morfologia","total","relativo");
    @tab2 = &do_complex_morphological_table("categoria","xycat","Class. morfolgica. Forma relativa,\nCenrio total, por categorias.");

    &print_morf_tables(@tab1,@tab2);
    print OUT "<H5><a name=\"$chapter.2.2.2\">$chapter.2.2.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_morphological_table("categoria",$runs,"morfologia","selectivo","relativo");
    @tab2 = &do_complex_morphological_table("categoria","xycat","Class. morfolgica. Forma relativa,\nCenrio selectivo, por categorias.");
    &print_morf_tables(@tab1,@tab2);

### Morfologia Resultados por gnero textual
        
    print OUT "<H4><a name=\"$chapter.3\">$chapter.3 Resultados por gnero textual</H4>\n";
    
### Morfologia Resultados por gnero textual Forma de avaliao Absoluta
    

    print OUT "<H4><a name=\"$chapter.3.1\">$chapter.3.1 Forma de avaliao absoluta</H4>\n";
    print OUT "<H5><a name=\"$chapter.3.1.1\">$chapter.3.1.1 Cenrio total </H5>\n";
    @tab1 = &do_stat_morphological_table("gnero textual",$runs,"morfologia","total","absoluto");
    @tab2 = &do_complex_morphological_table("gnero textual","xycat","Class. morfolgica. Forma absoluta,\nCenrio total, por gnero textual.");
    &print_morf_tables(@tab1,@tab2);

    print OUT "<H5><a name=\"$chapter.3.1.2\">$chapter.3.1.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_morphological_table("gnero textual",$runs,"morfologia","selectivo","absoluto");
    @tab2 = &do_complex_morphological_table("gnero textual","xycat","Class. morfolgica. Forma absoluta,\nCenrio selectivo, por gnero textual.");
    &print_morf_tables(@tab1,@tab2);

    
### Morfologia Resultados por gnero textual Forma de avaliao Relativa
    
    print OUT "<H4><a name=\"$chapter.3.2\">$chapter.3.2 Forma de avaliao relativa</H4>\n";
    print OUT "<H5><a name=\"$chapter.3.2.1\">$chapter.3.2.1 Cenrio total </H5>\n";
    @tab1 = &do_stat_morphological_table("gnero textual",$runs,"morfologia","total","relativo");
    @tab2 = &do_complex_morphological_table("gnero textual","xycat","Class. morfolgica. Forma relativa,\nCenrio total, por gnero textual.");
    &print_morf_tables(@tab1,@tab2);

    print OUT "<H5><a name=\"$chapter.3.2.2\">$chapter.3.2.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_morphological_table("gnero textual",$runs,"morfologia","selectivo","relativo");
    @tab2 = &do_complex_morphological_table("gnero textual","xycat","Class. morfolgica. Forma relativa,\nCenrio selectivo, por gnero textual.");
    &print_morf_tables(@tab1,@tab2);

### Morfologia Resultados por variante
    
    print OUT "<H4><a name=\"$chapter.4\">$chapter.4 Resultados por variante</H4>\n";
    
### Morfologia Resultados por variante Forma de avaliao Absoluta
    
    print OUT "<H4><a name=\"$chapter.4.1\">$chapter.4.1 Forma de avaliao absoluta</H4>\n";
    print OUT "<H5><a name=\"$chapter.4.1.1\">$chapter.4.1.1 Cenrio total </H5>\n";
    @tab1 = &do_stat_morphological_table("variante",$runs,"morfologia","total","relativo");
    @tab2 = &do_complex_morphological_table("variante","xycat","Class. morfolgica. Forma absoluta,\nCenrio total, por variante.");
    &print_morf_tables(@tab1,@tab2);

    print OUT "<H5><a name=\"$chapter.4.1.2\">$chapter.4.1.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_morphological_table("variante",$runs,"morfologia","selectivo","relativo");
    @tab2 = &do_complex_morphological_table("variante","xycat","Class. morfolgica. Forma absoluta,\nCenrio selectivo, por variante.");
    &print_morf_tables(@tab1,@tab2);    

### Morfologia Resultados por gnero textual Forma de avaliao Relativa
    
    print OUT "<H4><a name=\"$chapter.4.2\">$chapter.4.2 Forma de avaliao relativa</H4>\n";
    print OUT "<H5><a name=\"$chapter.4.2.1\">$chapter.4.2.1 Cenrio total </H5>\n";
    @tab1 = &do_stat_morphological_table("variante",$runs,"morfologia","total","relativo");
    @tab2 = &do_complex_morphological_table("variante","xycat","Class. morfolgica. Forma relativa,\nCenrio total, por variante.");
    &print_morf_tables(@tab1,@tab2);

   print OUT "<H5><a name=\"$chapter.4.2.2\">$chapter.4.2.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_morphological_table("variante",$runs,"morfologia","selectivo","relativo");
    @tab2 = &do_complex_morphological_table("variante","xycat","Class. morfolgica. Forma relativa,\nCenrio selectivo, por variante.");
    &print_morf_tables(@tab1,@tab2);    
    &breakpage;   
 }

###############################
### Tarefa de Semntica     ###
###############################

if ($do_semantica eq "true") {
    
    $chapter++; $current_task="classificao semntica";$curr_task="semntica";

### Semntica Resultados Globais
    
    print OUT "<H3><a name=\"$chapter\">$chapter. Tarefa de $current_task</h3>\n";   
    print OUT "<H4><a name=\"$chapter.1\">$chapter.1 Resultados globais</H4>\n";
    
### Semntica Forma de avaliao Absoluta
    
    print OUT "<H4><a name=\"$chapter.1.1\">$chapter.1.1 Forma de avaliao absoluta</H4>\n";
 
    $filename = &getFilenameString($runs,"semantica","absoluto","total","");
    &do_simple_semantic_table("<H5><a name=\"$chapter.1.1.1\">$chapter.1.1.1 Cenrio total </H5>\n","absoluto",$filename,"bar,xyrun");

    $filename = &getFilenameString($runs,"semantica","absoluto","selectivo","");
    &do_simple_semantic_table("<H5><a name=\"$chapter.1.1.2\">$chapter.1.1.2 Cenrio selectivo </H5>\n","absoluto",$filename,"bar,xyrun");

### Semntica Forma de avaliao Relativa
    
    print OUT "<H4>$chapter.1.2 Forma de avaliao relativa</H4>\n";
 
    $filename = &getFilenameString($runs,"semantica","relativo","total","");
    &do_simple_semantic_table("<H5><a name=\"$chapter.1.2.1\">$chapter.1.2.1 Cenrio total </H5>\n","relativo",$filename,"bar,xyrun");

    $filename = &getFilenameString($runs,"semantica","relativo","selectivo","");
    &do_simple_semantic_table("<H5><a name=\"$chapter.1.2.2\">$chapter.1.2.2 Cenrio selectivo </H5>\n","relativo",$filename,"bar,xyrun");

### Semntica Resultados por categorias
    
    print OUT "<H4><a name=\"$chapter.2\">$chapter.2 Resultados por categorias</H4>\n";
    
### Semntica Resultados por categorias Forma de avaliao Absoluta
    
    print OUT "<H4><a name=\"$chapter.2.1\">$chapter.2.1 Forma de avaliao absoluta</H4>\n";
    print OUT "<H5><a name=\"$chapter.2.1.1\">$chapter.2.1.1 Cenrio total </H5>\n";
    @tab1 = &do_stat_semantic_table("categoria",$runs,"semantica","total","absoluto");
    @tab2 = &do_complex_semantic_table("categoria","absoluto","xycat","Class. semntica. Forma absoluta,\nCenrio total, por categorias.");

    &print_sem_tables(@tab1,@tab2);
    print OUT "<H5><a name=\"$chapter.2.1.2\">$chapter.2.1.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_semantic_table("categoria",$runs,"semantica","selectivo","absoluto");
    @tab2 = &do_complex_semantic_table("categoria","absoluto","xycat","Class. semntica. Forma absoluta,\nCenrio selectivo, por categorias.");
    &print_sem_tables(@tab1,@tab2);    


### Semntica Resultados por categorias Forma de avaliao Relativa
    
    print OUT "<H4><a name=\"$chapter.2.2\">$chapter.2.2 Forma de avaliao relativa</H4>\n";
    print OUT "<H5><a name=\"$chapter.2.2.1\">$chapter.2.2.1 Cenrio total </H5>\n";   
    @tab1 = &do_stat_semantic_table("categoria",$runs,"semantica","total","relativo");
    @tab2 = &do_complex_semantic_table("categoria","relativo","xycat","Class. semntica. Forma relativa,\nCenrio total, por categorias.");
    &print_sem_tables(@tab1,@tab2);
   
    print OUT "<H5><a name=\"$chapter.2.2.2\">$chapter.2.2.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_semantic_table("categoria",$runs,"semantica","selectivo","relativo");
    @tab2 = &do_complex_semantic_table("categoria","relativo","xycat","Class. semntica. Forma relativa,\nCenrio selectivo, por categorias.");
    &print_sem_tables(@tab1,@tab2);

### Semntica Resultados por gneros
    
    print OUT "<H4><a name=\"$chapter.3\">$chapter.3 Resultados por gnero textual</H4>\n";
    
### Semntica Resultados por gneros Forma de avaliao Absoluta
    
    print OUT "<H4><a name=\"$chapter.3.1\">$chapter.3.1 Forma de avaliao absoluta</H4>\n";
    print OUT "<H5><a name=\"$chapter.3.1.1\">$chapter.3.1.1 Cenrio total </H5>\n";   
    @tab1 = &do_stat_semantic_table("gnero textual",$runs,"semantica","total","absoluto");
    @tab2 = &do_complex_semantic_table("gnero textual","absoluto","xycat","Class. semntica. Forma absoluta,\nCenrio total, por gnero textual.");
    &print_sem_tables(@tab1,@tab2);
    print OUT "<H5><a name=\"$chapter.3.1.2\">$chapter.3.1.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_semantic_table("gnero textual",$runs,"semantica","selectivo","absoluto");
    @tab2 = &do_complex_semantic_table("gnero textual","absoluto","xycat","Class. semntica. Forma absoluta,\nCenrio selectivo, por gnero textual.");
    &print_sem_tables(@tab1,@tab2);

### Semntica Resultados por gneros Forma de avaliao Relativa
    
    print OUT "<H4><a name=\"$chapter.3.2\">$chapter.3.2 Forma de avaliao relativa</H4>\n";
    print OUT "<H5><a name=\"$chapter.3.2.1\">$chapter.3.2.1 Cenrio total </H5>\n";   
    @tab1 = &do_stat_semantic_table("gnero textual",$runs,"semantica","total","relativo");
    @tab2 = &do_complex_semantic_table("gnero textual","relativo","xycat","Class. semntica. Forma relativa,\nCenrio total, por gnero textual.");
    &print_sem_tables(@tab1,@tab2);
    print OUT "<H5><a name=\"$chapter.3.2.2\">$chapter.3.2.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_semantic_table("gnero textual",$runs,"semantica","selectivo","relativo");
    @tab2 = &do_complex_semantic_table("gnero textual","relativo","xycat","Class. semntica. Forma relativa,\nCenrio selectivo, por gnero textual.");
    &print_sem_tables(@tab1,@tab2);

### Semntica Resultados por variante
    
    print OUT "<H4><a name=\"$chapter.4\">$chapter.4 Resultados por variante</H4>\n";
    
### Semntica Resultados por variante Forma de avaliao Absoluta
    
    print OUT "<H4><a name=\"$chapter.4.1\">$chapter.4.1 Forma de avaliao absoluta</H4>\n";
    print OUT "<H5><a name=\"$chapter.4.1.1\">$chapter.4.1.1 Cenrio total </H5>\n";   
    @tab1 = &do_stat_semantic_table("variante",$runs,"semantica","total","absoluto");
    @tab2 = &do_complex_semantic_table("variante","absoluto","xycat","Class. semntica. Forma absoluta,\nCenrio total, por variante.");
    &print_sem_tables(@tab1,@tab2);
    print OUT "<H5><a name=\"$chapter.4.1.2\">$chapter.4.1.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_semantic_table("variante",$runs,"semantica","selectivo","absoluto");
    @tab2 = &do_complex_semantic_table("variante","absoluto","xycat","Class. semntica. Forma absoluta,\nCenrio selectivo, por variante.");
    &print_sem_tables(@tab1,@tab2);

 ### Semntica Resultados por variante Forma de avaliao Relativa
    
    print OUT "<H4><a name=\"$chapter.4.2\">$chapter.4.2 Forma de avaliao relativa</H4>\n";
    print OUT "<H5><a name=\"$chapter.4.2.1\">$chapter.4.2.1 Cenrio total </H5>\n";   
    @tab1 = &do_stat_semantic_table("variante",$runs,"semantica","total","relativo");
    @tab2 = &do_complex_semantic_table("variante","relativo","xycat","Class. semntica. Forma relativa,\nCenrio total, por variante.");
    &print_sem_tables(@tab1,@tab2);
    print OUT "<H5><a name=\"$chapter.4.2.2\">$chapter.4.2.2 Cenrio selectivo </H5>\n";
    @tab1 = &do_stat_semantic_table("variante",$runs,"semantica","selectivo","relativo");
    @tab2 = &do_complex_semantic_table("variante","relativo","xycat","Class. semntica. Forma relativa,\nCenrio selectivo, por variante.");
    &print_sem_tables(@tab1,@tab2);
    close(OUT);   
}

############
### SUBS ###
############


### SEMANTICA #####


sub abrir_tabela {
# Abrir cabealho de tabela
# argumentos:
    # Task - ("identificao", "morfologia" ou "semntica")
    # Column - Coluna de categoria ("" para no usar, "XX" para colocar na 1 coluna)
    # Size - tamanho da tabela (small ou Large)
    my ($task,$column,$size) = @_;  
    undef($buffer);  my $buffer="<table border>\n<tr bgcolor=cccccc>\n";

    if (length($column)>0) {
	$buffer .= "<td align=center>".ucfirst($column)."</td>";
    }
    if ($task eq "identificao") {
	$buffer .= "<td>Posio</Td><td>Preciso (%)</td><td>Abrangncia (%)</td><td>Medida F</TD><td>Erro combinado</td><td>Sobre-<BR>gerao</td><td>Sub-<BR>gerao</b></td>\n</tr>\n";
    }
    elsif ($task eq "morfologia") {
	$buffer .= "<td>Posio</Td><td>Preciso (%)</td><td>Abrangncia (%)</td><td>Medida F</TD>";
	if ($size eq "large") {
	    $buffer .= "<td>Sobre-<BR>especificao</td><td>Sobre-<BR>gerao</td><td>Sub-<BR>gerao</b></td>";
	}
	$buffer .= "\n</tr>\n";
    } 
    elsif ($task eq "semntica") {
	if ($size eq "small") {
	    $buffer .= "<td>Posio</Td><td>Preciso (%)</td><td>Abrangncia (%)</td><td>Medida F</TD>";
	} elsif ($size eq "large") {
	    $buffer .= "<td>Posio</Td><td>Preciso (%)</td><td>Abrangncia (%)</td><td>Medida F</TD><td>Sobre-<BR>gerao</td><td>Sub-<BR>gerao</b></td>";
	}
	$buffer .= "\n</tr>\n";
    } 
    return $buffer;
}

sub do_complex_semantic_table {
    # criar as vrias tabelas para a semntica, a partir dos ficheiros do sulto 
    # argumentos:
        # Task - ("identificao", "morfologia" ou "semntica")
        # Scenery (absoluto ou relativo), pois o relativo gera 4 tabelas e o absoluto 3.
        # graph_yes_no - grficos a acrescentar
        # graph-title - Ttulo do grfico

    ($type,$scenery,$graph_yes_no,$graph_title) = @_;
    $main_type=$type; # Usar cpia, o main_type., pois o $type altera-se.
    $file = shift(@semantica_files);
    undef(@buffer);   @buffer=();
    undef(@buffergraph);   @buffergraph=();
    open(IN, "<".$directoria_semantica.$file) || die ("Erro: no abri $directoria_semantica.$file");
    print STDOUT "A ler agora $directoria_semantica.$file...\n" if $file_verbose;
        
# Abrir as 3 tabelas
    undef(@buffer);
    @buffer=();
    
    if ($scenery eq "absoluto") {
	for ($j=0; $j<scalar(@sem_abs_tables); $j++) {
	    $buffer[$j] .= &abrir_tabela("semntica",$type,$sem_table_abs_size[$j]);
	}
	for ($i=0; $i<$number_of_itens{$type}; $i++) {
	    for ($j=0; $j<scalar(@sem_abs_tables); $j++) {
		%results = &interpretar_relatorio_html_sultao($type,$graph_yes_no);
		$buffer[$j] .= $results{"buffer"};
	    }
	}
	for ($j=0; $j<scalar(@sem_abs_tables); $j++) {
	    $buffer[$j] .= &fechar_tabela;
	    if($graph_yes_no =~ /xycat/) {
		%results = &makeGraphXYrun($buffer[$j],$main_type,$graph_yes_no,$graph_title);
		$buffer[$j] .= &printGraph($results{"namegraphxycat"},"xycat",$results{"xycatlegend"});
	    }
	}
    } elsif ($scenery eq "relativo") {
	for ($j=0; $j<scalar(@sem_rel_tables); $j++) {
	    $buffer[$j] .= &abrir_tabela("semntica",$type,$sem_table_rel_size[$j]);
	}
	for ($i=0; $i<$number_of_itens{$type}; $i++) {
	    for ($j=0; $j<scalar(@sem_rel_tables); $j++) {
		%results = &interpretar_relatorio_html_sultao($type,$graph_yes_no);
		$buffer[$j] .=  $results{"buffer"};
	    }
	}	
	for ($j=0; $j<scalar(@sem_rel_tables); $j++) {
	    $buffer[$j] .= &fechar_tabela;
	     if($graph_yes_no =~ /xycat/) {
		%results = &makeGraphXYrun($buffer[$j],$main_type,$graph_yes_no,$graph_title);
		$buffer[$j] .= &printGraph($results{"namegraphxycat"},"xycat",$results{"xycatlegend"});
	    }
	}
    }
    close(IN);
     return @buffer;
}

sub do_simple_semantic_table {
    # criar as tabelas simples (globais) para a semntica, a partir dos ficheiros do sulto 
    # argumentos:
        # Text - A escrever antes da tabela
        # Scenery (absoluto ou relativo), pois o relativo gera 4 tabelas e o absoluto 3.
        # filename - nome do ficheiro a ler
        # graph_yes_no - grficos a acrescentar

    ($text,$scenery,$filename,$graph_yes_no) = @_;
    $file = shift(@semantica_files);
    open(IN, "<".$directoria_semantica.$file) || die ("Erro: no abri $directoria_semantica.$file");
    open(IN2, "<$directoria_ida$filename") || die ("Erro: no abri $directoria_ida.$filename");

    print STDOUT "A ler agora $directoria_semantica.$file...\nA ler agora $directoria_ida$filename...\n" if $file_verbose;
    print OUT $text;
    @stat_sem_tables = &parseSemanticStats(IN2);
    close(IN2);

   if ($scenery eq "absoluto") {
       for ($i=0; $i<scalar(@sem_abs_tables); $i++) {
	print OUT "<B>Avaliao global da classificao semntica $sem_abs_tables[$i]</B><BR>\n";
	$stat_sem_tables[$i] =~ /(.*)\t(.*)\t(.*)\t(.*)\t(.*)/;

	if ($sem_abs_tables[$i] eq "combinada") {
	    print OUT "<font size=2>Valor mximo possvel para a CSC na CD: <B>".&converter($1)."</B>.\n";
	    print OUT "Valor mximo possvel para a CSC do sistema: <B>".&converter($2)."</B>.<BR>\n";
	    # Estes podem ser adicionados tambm:
	    # print OUT "Preciso mxima do sistema: <B>".&converter($3)."</B>. Abrangncia mxima do sistema: <B>";
	    # print OUT &converter($4)."</B>. Medida F: <B>".&converter($5)."</B><BR>\n";
	} else {
	    print OUT "<font size=2>Total na CD: <B>$1</B>. Identificadas: $2. ";
	    print OUT "<BR>Total correctas: ".&converter($3)." (".&getPerc($3,$1)."). Total esprios: $4 (";
	    print OUT &getPerc($4,$1)."). Total em falta: ".&converter($5)." (".&getPerc($5,$1)."). </FONT><BR>";
	}

	print OUT &abrir_tabela("semntica","",$sem_table_abs_size[$i]);

	# preparar ttulo do grfico
	$text =~ /Cenrio\s(\w+)/;
	$graph_title = "Class. semntica $sem_abs_tables[$i].\nForma absoluta, cenrio $1.";

	%results = &interpretar_relatorio_html_sultao("",$graph_yes_no,$graph_title);
	print OUT $results{"buffer"};
	print OUT &fechar_tabela;
	if ($graph_yes_no =~ /bar/) {print OUT &printGraph($results{"bar"},"bar");}
	if ($graph_yes_no =~ /xyrun/) {print OUT &printGraph($results{"namegraphxyrun"},"xyrun",$results{"xyrunlegend"});}
      }

    }  elsif ($scenery eq "relativo") {
       for ($i=0; $i<scalar(@sem_rel_tables); $i++) {
	print OUT "<B>Avaliao global da classificao semntica $sem_rel_tables[$i]</B><BR>\n";
	$stat_sem_tables[$i] =~ /(.*)\t(.*)\t(.*)\t(.*)\t(.*)/;

	if ($sem_abs_tables[$i] eq "combinada") {
	    print OUT "<font size=2>Valor mximo possvel para a CSC na CD: <B>".&converter($1)."</B>.<BR>\n";
	    print OUT "Valor mximo possvel para a CSC do sistema: <B>".&converter($2)."</B>.<BR>\n";
	    # Estes podem ser adicionados tambm:
            # print OUT "Preciso mxima do sistema: <B>".&converter($3)."</B>. Abrangncia mxima do sistema: <B>";
	    # print OUT &converter($4)."</B>. Medida F: <B>".&converter($5)."</B><BR>\n";
	} else {
	    print OUT "<font size=2>Total na CD: <B>$1</B>. Identificadas: $2 .";#(".&getPerc($2,$1)."). ";
	    print OUT "<BR>Total correctas: ".&converter($3)." (".&getPerc($3,$1)."). Total esprios: $4 (";
	    print OUT &getPerc($4,$1)."). Total em falta: ".&converter($5)." (".&getPerc($5,$1)."). </FONT><BR>";
	}

	print OUT &abrir_tabela("semntica","",$sem_table_rel_size[$i]);

	# preparar ttulo do grfico
	$text =~ /Cenrio\s(\w+)/;
	$graph_title = "Class. semntica $sem_rel_tables[$i].\nForma relativa, cenrio $1.";

	%results = &interpretar_relatorio_html_sultao("",$graph_yes_no,$graph_title);
	print OUT $results{"buffer"};
	print OUT &fechar_tabela;
	if ($graph_yes_no =~ /bar/) {print OUT &printGraph($results{"bar"},"bar");}
	if ($graph_yes_no =~ /xyrun/) {print OUT &printGraph($results{"namegraphxyrun"},"xyrun",$results{"xyrunlegend"});}
    }
   }
    close(IN);
}

sub do_stat_semantic_table {
    # criar as tabelas de estatsticas (ids2sem) para a semntica
    # argumentos:
        # what - qual categoria ("categoria, gnero textual, variante);
        # run - nome da run a procurar nos HTML
        # type - tipo (semantica, morfologia, etc).
        # tot_sel - Total ou Selectivo
        # abs_rel - Absoluto ou Relativo

    # Exemplo a chamar a funo: &do_stat_semantica_table("categoria",$runs,"semantica","total","absoluto");

    ($what,$run,$type,$tot_sel,$abs_rel) = @_;
    undef(@main_sem_table);

    if ($what eq "categoria") {@rows = @categoria;}
    elsif ($what eq "gnero textual") {@rows = @genero;}
    elsif ($what eq "variante") {@rows = @variante;} 

    if ($abs_rel eq "absoluto") {
	@sem_table = @sem_abs_tables;
    } elsif ($abs_rel eq "relativo"){
	@sem_table = @ sem_rel_tables;
    }

    for ($i=0; $i<scalar(@sem_table); $i++) {
	if ($sem_table[$i] eq "combinada") {
	    $main_sem_table[$i]= "<TABLE BORDER>\n<TR bgcolor=ffffcc>\n<TD align=center>".ucfirst($what)."</TD><TD align=center>Valor mximo Possvel<BR>para a CSC na CD</TD><TD align=center>Valor mximo Possvel<BR>para a CSC no sistema</TD><TD align=center>Preciso</TD><TD align=center>Abrangncia</TD><TD align=center>Medida F</TD>\n</TR>\n";
	} else {
	    $main_sem_table[$i]= "<TABLE BORDER>\n<TR bgcolor=ffffcc>\n<TD rowspan=2 align=center>".ucfirst($what)."</TD><TD rowspan=2 align=center>Total CD</TD><TD rowspan=2 align=center>Identificadas</TD><TD colspan=2 align=center>Correctas</TD><TD colspan=2 align=center>Esprias</TD><TD colspan=2 align=center>Em Falta</TD>\n</TR>\n<TR>\n<TD>Total</TD><TD>%</TD><TD>Total</TD><TD>%</TD><TD>Total</TD><TD>%</TD>\n</TR>\n";
	}
    }

    foreach $it (@rows) {
	$index = 0;
	$filename = &getFilenameString($run,$type,$abs_rel,$tot_sel,$it);

	if (-e "".$directoria_ida.$filename) {
	    open(IN2, "<$directoria_ida$filename")  || die ("Erro: no abri $directoria_ida$filename");
	    print STDOUT "A ler agora $directoria_ida$filename...\n" if $file_verbose;
	    
	    @itens = &parseSemanticStats(IN2); # d os valores (#CD\t#ident) de combinada, nmero e gnero
	    close(IN2);
	    for ($i=0; $i<scalar(@sem_table); $i++) {
		$itens[$i] =~ /(.*)\t(.*)\t(.*)\t(.*)\t(.*)/;
		if ($sem_table[$i] eq "combinada") {
		    $main_sem_table[$i] .= " <TR>\n<TD>$pretty_print{$it}</TD><TD>".&converter($1)."</TD><TD>".&converter($2)."</TD>";
		    $main_sem_table[$i] .= "<TD>".&converter($3)."</TD><TD>".&converter($4)."</TD><TD>".&converter($5)."</TD>\n</TR>\n";
		} else {
		    $main_sem_table[$i] .= " <TR>\n<TD>$pretty_print{$it}</TD><TD>$1</TD><TD>$2</TD><TD>".&converter($3)."</TD><TD>";
		    $main_sem_table[$i] .= &getPerc($3,$1)."</TD></TD><TD>$4</TD><TD>".&getPerc($4,$1)."</TD></TD><TD>$5</TD><TD>";
		    $main_sem_table[$i] .= &getPerc($5,$1)."</TD>\n</TR>\n";
		}
	    }
	    
	} else {
	    print STDOUT "No encontrei $directoria_ida$filename, a saltar \n" if $file_verbose;
	}
    }

    for ($i=0; $i<scalar(@sem_table); $i++) {
	$main_sem_table[$i].= &fechar_tabela;
    }
    return @main_sem_table;
}

sub parseSemanticStats {
    # l os ficheiros ids2sem

    $filestream = shift;
    @output=(); @stat_cd=(); @stat_ident=();@stat_cor=();@stat_esp=();@stat_emf=();
    $index="";
    
    # A ordem para escrever no relatrio individual  a mesma dos HTML do sulto, ou seja: 
    # combinada, plana, categoria (e tipos, nas seces de relativos). 
    # A ordem que leio dos relatrios ida2sem, : 
    # categorias, tipos, combinada, plana. Por isso uso o index, para poder trocar a ordem.
    
    # criao de ndices correctos.
    while ($line2 = <$filestream>) {
	if ($line2 =~ /^Avalia/) {
	    if ($line2 =~ /por Categorias/) {$index = 2;}
	    if ($line2 =~ /por Tipos/) {$index = 3;}
	    if ($line2 =~ /Combinada/) {$index = 0;}
	    if ($line2 =~ /Plana/) {$index = 1;}
	}
	if ($line2 =~ /Total de EMs classificadas na CD: (\d+)/) {$stat_cd[$index]=$1;}
	if ($line2 =~ /Total de EMs classificadas pelo sistema: (\d+)/) {$stat_ident[$index]=$1;}
	if ($line2 =~ /Total Correctos: ([\d\.]+)/) {$stat_cor[$index]=$1;}
	if ($line2 =~ /Esp\wrios: ([\d\.]+)/) {$stat_esp[$index]=$1;}
	if ($line2 =~ /Em Falta: ([\d\.]+)/) {$stat_emf[$index]=$1;}

	# Linhas especiais da Classificao Semntica Combinada
	# vou usar os arrays existentes, embora queiram dizer coisas diferentes
	if ($index == 0) {
	    if ($line2 =~ /Combinada na CD: ([\d\.]+)/) {$stat_cd[$index]=$1;} 
	    if ($line2 =~ /Combinada do sistema: ([\d\.]+)/) {$stat_ident[$index]=$1;} 
	    if ($line2 =~ /Precis\wo M\wxima do Sistema: ([\d\.]+)/) {$stat_cor[$index]=$1;} 
	    if ($line2 =~ /Abrang\wncia M\wxima na CD: ([\d\.]+)/) {$stat_esp[$index]=$1;} 
	    if ($line2 =~ /Medida F: ([\d\.\w]+)/) {
		$stat_emf[$index]= &takeOffNaN($1);
	    } 
	}   
    }

    # usei stat_cd, pois assim o valor varia entre o scalar de sem_abs_tables e sem_rel_tables (3 e 4)
    for ($i=0; $i<scalar(@stat_cd);$i++) { 	
	push(@output, "$stat_cd[$i]\t$stat_ident[$i]\t$stat_cor[$i]\t$stat_esp[$i]\t$stat_emf[$i]\n");
    }
    return @output;
}    

sub print_sem_tables($howmuch) {
    # Escreve as tabelas de semntica. $howmuch pode ser 6 ou 8 (pois absoluto gera 3 tabelas, relativo gera 4 tabelas)
    @itens = @_;
    $howmuch = scalar(@_)/2;
    @tab1 = @itens[0..($howmuch-1)];
    @tab2 = @itens[$howmuch..scalar(@_)];
    if ($howmuch == 4) {@sem_table = @sem_rel_tables;}
    elsif ($howmuch == 3) {@sem_table = @sem_abs_tables;}

    for ($j=0; $j<$howmuch; $j++) {
	print OUT "<B>Avaliao global da classificao semntica $sem_table[$j]</B><P>\n";
	print OUT $tab1[$j]."<P>".$tab2[$j]."<P>\n";
    }
}

### MORFOLOGIA ###

sub do_simple_morphological_table {
    # criar as tabelas simples (globais) para a morfologia, a partir dos ficheiros do sulto 
    # argumentos:
        # Text - A escrever antes da tabela
        # Scenery (absoluto ou relativo), pois o relativo gera 4 tabelas e o absoluto 3.
        # filename - nome do ficheiro a ler
        # graph_yes_no - grficos a acrescentar


    ($text,$scenery,$filename,$graph_yes_no) = @_;
    $file = shift(@morfologia_files);
    open(IN, "<".$directoria_morfologia.$file) || die ("Erro: no abri $directoria_morfologia.$file");
    open(IN2, "<".$directoria_ida.$filename) || die ("Erro: no abri $directoria_ida.$filename");

    print STDOUT "A ler agora $directoria_morfologia.$file...\nA ler agora $directoria_ida.$filename...\n" if $file_verbose;
    print OUT $text;
    @stat_morf_tables = &parseMorfStats(IN2);
    close(IN2);
    for ($i=0; $i<scalar(@morf_tables); $i++) {
	print OUT "<B>Avaliao global da classificao morfolgica ($morf_tables[$i])</B><BR>\n";
	$stat_morf_tables[$i] =~ /(.*)\t(.*)/;
	print OUT "<font size=2>Total na CD: <B>$1</B>. Identificadas: <B>$2</B>. ";
	print OUT &abrir_tabela("morfologia","",$morf_tables_size[$i]);

	$text =~ /Cenrio\s(\w+)/;
	$scenery2=$scenery; $scenery2 =~ s/o/a/g; # maneira rpida de converter absoluto para absoluta, sem estragar o processamento...
	$graph_title = "Class. morfolgica ($morf_tables[$i]).\nForma $scenery2, cenrio $1.";

	%results = &interpretar_relatorio_html_sultao("",$graph_yes_no,$graph_title);
	print OUT $results{"buffer"};
	print OUT &fechar_tabela;
	if ($graph_yes_no =~ /bar/) {print OUT &printGraph($results{"bar"},"bar");}
	if ($graph_yes_no =~ /xyrun/) {print OUT &printGraph($results{"namegraphxyrun"},"xyrun",$results{"xyrunlegend"});}

    }
    close(IN);
}

sub parseMorfStats {
    # ler os ficheiros gerados pelo ida2mor

    $filestream = shift;
    @output=(); @stat_cd=(); @stat_ident=();
    $index=""; 
    # A ordem para escrever  combinada, Nmero e Gnero. Eu leio do ida2mor Nmero, Gnero e Combinada. Por isso uso o index.

    while ($line2 = <$filestream>) {
	if ($line2 =~ / - N\wmero/) {$index = 1;}
	if ($line2 =~ / - G\wnero/) {$index = 2;}
	if ($line2 =~ / - Combinada/) {$index = 0;}
	if ($line2 =~ /Total de classifica\w\wes da CD: (\d+)/) {$stat_cd[$index]=$1;}
	if ($line2 =~ /Total de classifica\w\wes do sistema : (\d+)/) {$stat_ident[$index]=$1;}
    }
    for ($i=0; $i<scalar(@morf_tables);$i++) {
	push(@output, "$stat_cd[$i]\t$stat_ident[$i]\n");
    }
    return @output;
}

sub do_complex_morphological_table {
    # escrever as tabelas de morfologia para as discriminaes.
    # parmetros:
        # type - tipo ("" para nada, "XXX" para escrever XXX na primeira coluna)
        # graph_yes_no - tipo de grfico a colocar
        # graph_title - ttulo do grfico 

    ($type,$graph_yes_no,$graph_title) = @_;
    $main_type = $type; # ver do_complex_semantic_table
    $file = shift(@morfologia_files);
    undef(@buffer);  @buffer=();  undef(@buffergraph);  @buffergraph=();

    open(IN, "<".$directoria_morfologia.$file) || die ("Erro: no abri $directoria_morfologia.$file");
    print STDOUT "A ler agora $directoria_morfologia.$file...\n" if $file_verbose;
    
    for ($j=0; $j<scalar(@morf_tables); $j++) {
	$buffer[$j] .= &abrir_tabela("morfologia",$type,$morf_tables_size[$j]);
    }
    for ($i=0; $i<$number_of_morf_itens{$type}; $i++) {
	
	for ($j=0; $j<scalar(@morf_tables); $j++) {
	    %results = &interpretar_relatorio_html_sultao($type,$graph_yes_no);
	    $buffer[$j] .= $results{"buffer"};
	}
    }   
    for ($j=0; $j<scalar(@morf_tables); $j++) {
	$buffer[$j] .= &fechar_tabela;
	if($graph_yes_no =~ /xycat/) {
	    %results = &makeGraphXYrun($buffer[$j],$main_type,$graph_yes_no,$graph_title);
	    $buffer[$j] .= &printGraph($results{"namegraphxycat"},"xycat",$results{"xycatlegend"});
	}
    }    
    close(IN);
    return @buffer;
}

sub print_morf_tables {
    # Escrever tabelas. H 3 tabelas para cada cenrio.
    @itens = @_;
    @tab1 = @itens[0..2];
    @tab2 = @itens[3..5];
    for ($j=0; $j<scalar(@morf_tables); $j++) {
	print OUT "Avaliao global da classificao morfolgica ($morf_tables[$j])</B><P>\n";
	print OUT $tab1[$j]."<P>".$tab2[$j]."<P>\n";
    }
}

sub do_stat_morphological_table {
    # Escrever as tabelas de estatsticas dadas pelo ida2mor.
    # parmetros: 
       # what - tipo de categorias (categoria, gnero,variante)
       # run - Nome da sada
       # type - Tipo de sada (morf, sem, etc)
       # tot_sel - Total ou Selectivo
       # abs_rel - Absoluto ou Relativo
    ($what,$run,$type,$tot_sel,$abs_rel) = @_;

    if ($what eq "categoria") {@rows = @categoria_morf;}
    elsif ($what eq "gnero textual") {@rows = @genero;}
    elsif ($what eq "variante") {@rows = @variante;} 

    # abrir as 3 tabelas
    for ($i=0; $i<scalar(@morf_tables); $i++) {
	$main_morf_table[$i]= "<TABLE BORDER>\n<TR bgcolor=ffffcc>\n<TD>".ucfirst($what)."</TD><TD>Total CD</TD><TD>Identificadas</TD></TR>\n";
    }
    foreach $it (@rows) {
	$index = 0;
	$filename = &getFilenameString($run,$type,$abs_rel,$tot_sel,$it);
	if (-e "".$directoria_ida.$filename) {
	    open(IN2, "<$directoria_ida$filename")  || die ("Erro: no abri $directoria_ida$filename");
	    print STDOUT "A ler agora $directoria_ida$filename...\n" if $file_verbose;
	    
	    @itens = &parseMorfStats(IN2); # d os valores (#CD\t#ident) de combinada, nmero e gnero
	    close(IN2);	    
	    for ($i=0; $i<scalar(@morf_tables); $i++) {
		$itens[$i] =~ /(.*)\t(.*)/;
		$main_morf_table[$i] .= " <TR><TD>$pretty_print{$it}</TD><TD>$1</TD><TD>$2</TD></TR>\n";
	    }
	} else {
	    print STDOUT "No encontrei $directoria_ida$filename, a saltar \n" if $file_verbose;
	}
    }

    for ($i=0; $i<scalar(@morf_tables); $i++) {
	$main_morf_table[$i].= &fechar_tabela;
    }
    return @main_morf_table;
}

### IDENTIFICACAO ###
   
sub do_simple_identification_table {
    # Escrever as tabelas de dados globais da identificao 
    # parmetros: 
       # text - Texto a escrever
       # filename - ficheiro a abrir
       # graph_yes_no - grficos a escrever
    ($text,$filename,$graph_yes_no) = @_;
    $file = shift(@identificacao_files);
    print OUT $text; 
    open(IN, "<".$directoria_identificacao.$file) || die ("Erro: no abri $directoria_identificacao.$file");
    open(IN2, "<".$directoria_ida.$filename) || die ("Erro: no abri $directoria_ida.$filename");
    print STDOUT "A ler agora $directoria_identificacao.$file ...\nA ler agora $directoria_ida.$filename\n" if $file_verbose;
    &parseIdentificationStats(IN2);  
    close(IN2);


    $text =~ /(Cenrio)\s(\w+)/;
    $graph_title = ucfirst($current_task).". $1 $2.";

    print OUT &abrir_tabela("identificao","");
    %results = &interpretar_relatorio_html_sultao("",$graph_yes_no,$graph_title);
    print OUT $results{"buffer"};
    print OUT &fechar_tabela;
    close(IN);
 
    if ($graph_yes_no =~ /bar/) {print OUT &printGraph($results{"bar"},"bar");}
    if ($graph_yes_no =~ /xyrun/) {print OUT &printGraph($results{"namegraphxyrun"},"xyrun",$results{"xyrunlegend"});}
}

sub parseIdentificationStats {
    # l os relatrios do ida2id, e escreve-os.

    $filestream = shift;
    while ($line2 = <$filestream>) {
	if ($line2 =~ /Total na CD: (\d+)/) {$stat_cd=$1;}
	if ($line2 =~ /Total Identificadas: (\d+)/) {$stat_ident=$1;}
	if ($line2 =~ /Total Correctos: (\d+)/) {$stat_cor=$1;}
	if ($line2 =~ /Total Ocorrncias Parcialmente Correctos: (\d+)/) {$stat_parcor=$1;}
	if ($line2 =~ /Esprios: (\d+)/) {$stat_esp=$1;}
	if ($line2 =~ /Em Falta: (\d+)/) {$stat_emf=$1;}
    }

    print OUT "<font size=2>Total na CD: <B>$stat_cd</B>. Identificadas: <B>$stat_ident</B>. ";
    print OUT "Correctas: <B>$stat_cor</B> (".&getPerc($stat_cor,$stat_cd).").<BR>Parcialmente Correctas: <B>$stat_parcor</B> ";
    print OUT "(".&getPerc($stat_parcor,$stat_cd)."). Esprias: <B>$stat_esp</B> (".&getPerc($stat_esp,$stat_cd)."). ";
    print OUT "Em Falta: <B>$stat_emf</B> (".&getPerc($stat_emf,$stat_cd).").</font>";
}

sub do_stat_identification_table {
    # Gera tabelas de estatsticas par aa identificao
    # parmetros: 
        # what -  O item da categora, gnero textual, variante, etc.
        # run - Nome da sada
        # type - caetgoria, gnero, variante
        # tot_sel - Total ou Selectivo
    ($what,$run,$type,$tot_sel) = @_;
    print OUT "<TABLE BORDER>\n<TR bgcolor=ffffcc>\n<TD rowspan=2>".ucfirst($what)."</TD><TD rowspan=2>Total CD</TD><TD rowspan=2>Identificadas</TD><TD colspan=2>Correctas</TD><TD colspan=2>Parcialmente<BR>correctas</TD><TD colspan=2>Esprias</TD><TD colspan=2>Em Falta</TD>\n</TR>\n<TR><TD>Total</TD><TD>%</TD><TD>Total</TD><TD>%</TD><TD>Total</TD><TD>%</TD><TD>Total</TD><TD>%</TD>\n</TR>\n";

    if ($what eq "categoria") {@rows = @categoria;}
    elsif ($what eq "gnero textual") {@rows = @genero;}
    elsif ($what eq "variante") {@rows = @variante;} 

    foreach $it (@rows) {
	$filename = &getFilenameString($run,$type,"",$tot_sel,$it);
	if (-e $directoria_ida.$filename) {
	    open(IN2, "<".$directoria_ida.$filename) || die ("Erro: no abri $directoria_ida.$filename");
	    print STDOUT "A ler agora $directoria_ida.$filename...\n" if $file_verbose;
	    while ($line2 = <IN2>) {
		if ($line2 =~ /Total na CD: (\d+)/) {$stat_cd=$1;}
		if ($line2 =~ /Total Identificadas: (\d+)/) {$stat_ident=$1;}
		if ($line2 =~ /Total Correctos: (\d+)/) {$stat_cor=$1;}
		if ($line2 =~ /Total Ocorrncias Parcialmente Correctos: (\d+)/) {$stat_parcor=$1;}
		if ($line2 =~ /Esprios: (\d+)/) {$stat_esp=$1;}
		if ($line2 =~ /Em Falta: (\d+)/) {$stat_emf=$1;}
	    }
	    
	    print OUT "<TR><TD>$pretty_print{$it}</TD><TD>$stat_cd</TD><TD>$stat_ident</TD>";
	    print OUT "<TD>$stat_cor</TD><TD>".&getPerc($stat_cor,$stat_cd)."</TD><TD>$stat_parcor</TD><TD>".&getPerc($stat_parcor,$stat_cd)."</TD>";
	    print OUT "<TD>$stat_esp</TD><TD>".&getPerc($stat_esp,$stat_cd)."</TD><TD>$stat_emf</TD><TD>".&getPerc($stat_emf,$stat_cd)."</TD></TR>\n";
	    close(IN2);
	} else {
	    print STDOUT "No encontrei $directoria_ida$filename, a saltar.\n" if $file_verbose;
	}
    }
    print OUT "</table><br>";
}

sub do_complex_identification_table {
    # gera as tabelas discriminadas, para a identificao
    # parmetros:
        # type - pode ser uma categoria, gnero ou vairante
        # graph_yes_no - Tipo de grfico
        # graph_title - ttulo do grfico

    ($type,$graph_yes_no,$graph_title) = @_;
    $file = shift(@identificacao_files);
    $buff="";

    open(IN, "<".$directoria_identificacao.$file) || die ("Erro: no abri $directoria_identificacao.$file");
    print STDOUT "A ler agora $directoria_identificacao.$file...\n" if $file_verbose;
    print OUT &abrir_tabela("identificao",$type);   
    for ($i=0; $i<$number_of_itens{$type}; $i++) {
	%results = &interpretar_relatorio_html_sultao($type,$graph_yes_no);
	$buff .= $results{"buffer"}."\n";
    }
    print OUT $buff;
    print OUT &fechar_tabela;
    if($graph_yes_no =~ /xycat/) {
	%results =&makeGraphXYrun($buff,$type,$graph_yes_no,$graph_title);
	print OUT &printGraph($results{"namegraphxycat"},"xycat",$results{"xycatlegend"});
    }
    close(IN);
}

sub makeGraphXYrun{ 
    # gera o grfico XY para as vrias sadas / sistemas 
    # parmetros: 
         # buff - Tabela que tem os valores para este grfico
         # type - Tipo de discriminao (categoria, gnero ou variante)
         # graph_yes_no - tipo de grfico
         # graph_title - ttulo do grfico

    my ($buff,$type,$graph_yes_no,$graph_title)=@_;
    undef($graph);
    undef(@data);
    undef(%returner); # esta hash colecciona os textos a escrever.
    my $graph;
    my @data=([],[],[]);   # guarda os valores dos dados para o grfico
    @lines = split("\n",$buff);
    
    foreach $it (@lines) {
	if ($it =~ /^<tr><td>(<\w>)*(\w+)(<\/\w>)*<\/td>(<td>.+<\/td>)*<\/tr>/)  {
	    # retira a categoria, e os vrios valores, e coloca-os num array
	    $category = $2; $itens = $4;
	    $itens =~ s/<td>//g;
	    $itens =~ s/<\/td>/#/g;
	    @array_itens = split("#",$itens);
	    unshift(@array_itens); # o ltimo elemento  vazio.
	    @values = @array_itens;
	   
	    if ($graph_yes_no =~ /xycat/) {
		# grfico x-y de categorias - colocar item, prec e abr.
		push(@{$data[0]},$category);
		push(@{$data[1]},&nohtml($array_itens[1]));
		push(@{$data[2]},&nohtml($array_itens[2]));
	    }	    
	}
    }
    
    #data2 fica com abrangncia nos X, preciso nos Y.
    @data2 = @data[2,1];
    $number_of_points = scalar(@{$data2[0]});
    print STDOUT "NUMBER OF POINTS FOR XYCAT: $number_of_points\n" if $data_verbose;

    if ($number_of_points > 0) {
	if ($type ne "variante") {
	    $graph = GD::Graph::points->new(270,300); 
	}else { 
	    $graph = GD::Graph::points->new(200,200); 
	}
	$graph->set(text_space=>16);
		
	$data_plot = GD::Graph::Data->new(); # criar os dados
	$data_plot->copy_from(\@data2);
	$values = $data_plot->copy();
	
	if ($type ne "variante" & $number_of_points>1) {
	    $graph->set(x_label => "Abrangncia (%)",y_label =>"Preciso (%)",title=>$graph_title,long_ticks=>1, 
			y_max_value=>100, y_min_value=>0, x_tick_number=>10, x_min_value=>0, x_max_value=>100,  
			y_tick_number=>10, y_label_skip=>1,show_values=>0,
			x_labels_vertical=>0,transparent=>0,fgclr=>"black");
	} else {
	    $graph->set(x_label => "Abrangncia (%)",y_label =>"Preciso (%)",title=>$graph_title,long_ticks=>1, 
			y_max_value=>100, y_min_value=>0,# x_tick_number=>10, x_min_value=>0, x_max_value=>100,  
			y_tick_number=>10, y_label_skip=>1,show_values=>0,
			x_labels_vertical=>0,transparent=>0,fgclr=>"black");
	}
	$graph->set_text_clr("black");		
	GD::Text->font_path( "/usr/lib/X11/fonts/TTF/");
	$graph->set_title_font(["luximr",gdMediumBoldFont],8);
	$graph->set_x_label_font(["luximr",gdMediumBoldFont],10);
	$graph->set_y_label_font(["luximr",gdMediumBoldFont],10);
	$graph->set_x_axis_font(["luximr",gdMediumBoldFont],8);
	$graph->set_y_axis_font(["luximr",gdMediumBoldFont],8);
	
	# H que desenhar primeiro o grfico
	$graph->plot($values);
	
	# obter as coordenadas dos pontos da 1 (e nica) srie   
	@serie = $graph->get_hotspot(1);
	
	# obter a imagem, para poder desenhar nela
	$draw = $graph->gd();
	
#   para escrever labels:
#	$draw->string(gdMediumBoldFont,$dots[1],$dots[3],${$data[0]}[$little_counter],$color);
	
	$cc = 0;
	$html_code_legend="<TABLE BORDER=0 cellspacing=1>\n";
	
	foreach $it (@serie) {
	    @dots = @{$it}; # retirar os valores do ponto, que esto na forma ['rect',x1,y1,x2,y2]	
	    $color = $draw->colorResolve($red[$cc],$green[$cc],$blue[$cc]);
	    $draw->rectangle($dots[1],$dots[3],$dots[2],$dots[4],$color);
	    $draw->fill($dots[1]+1,$dots[3]-1,$color);
	    $html_code_legend.="<TR>\n<TD width=10 height=10 bgcolor=$color_hex[$cc]><font size=1>&nbsp;&nbsp;&nbsp;&nbsp;</font></TD><TD><font size=1>".${$data[0]}[$cc]."</font></TD>\n</TR>\n";
	    $cc++;
	}
	$html_code_legend.="</TABLE>\n";
	$returner{"xycatlegend"}=$html_code_legend;	
	$returner{"namegraphxycat"} = &getGraphXYCatName;
	open(GRAPH,">imagens/".$returner{"namegraphxycat"}) || die ("Could not open output for graph ".$returner{"namegraphxycat"}.".\n");
	binmode GRAPH;
	$ext = $graph->export_format();
	print GRAPH $draw->$ext();
	close(GRAPH);
	print STDOUT "A criar imagem ".$returner{"namegraphxycat"}.".\n" if $image_verbose;
    } elsif ($number_of_points == 0) {
	$returner{"namegraphxycat"} = "";
    }
    return %returner;
}

### OTHER SUBS ###

sub printGraph {
    # escreve o grfico
    ($filename,$type,$legend)=@_;
    $buff_img = "";
    if (length($filename) >0) {
	if ($type =~ /bar|xy/) {$buff_img .= "<TABLE BORDER=0 valign=middle>\n<tr>\n<TD>\n";}
	$buff_img .= "<IMG SRC=\"imagens/$filename\">";
	if ($type =~ /xy/) {$buff_img .= "</TD>\n<TD>\n".$legend."</TD>\n</TR>\n</TABLE>\n";}
	if ($type =~ /bar/) {
	    $buff_img .= "</TD>\n<TD><TABLE BORDER=0><TR><TD width=10 height=10 bgcolor=ff0000><font size=1>&nbsp;&nbsp;&nbsp;&nbsp;</font></TD><TD> Preciso</TD></TR>\n";
	    $buff_img .= "<TR><TD width=10 height=10 bgcolor=00ff00><font size=1>&nbsp;&nbsp;&nbsp;&nbsp;</font></TD><TD> Abrangncia</TD></TR>\n";
	    $buff_img .= "<TR><TD width=10 height=10 bgcolor=0000ff><font size=1>&nbsp;&nbsp;&nbsp;&nbsp;</font></TD><TD> Medida F</TD></TR></TABLE>\n</TD></TR></TABLE>\n";
	}
	$buff_img .= "<P>";
    }
    return $buff_img;
}

sub getFilenameString {
    # Recebo parmetros do tipo ('palavras', 'semantica', 'absoluto', 'total' e 'web')
    # devolvo nome do ficheiro a ler, tipo 'palavras/semantica/palavras.alinhado.etq.verificado.avalida.total.web.emir.absoluto.altsem.ida2sem'
    
    ($run,$_type,$abs_rel,$tot_sel,$cat_gen_var) = @_;
    $end; $av;

    if (length($abs_rel) > 0) {$path_abs_rel = $abs_rel."/";}
    if (length($cat_gen_var) > 0) {$cat_gen_var = ".".$cat_gen_var;}

    if ($_type eq "semantica") {$end = "altsem.ida2sem"; $av = "emir.$abs_rel.";}
    elsif ($_type eq "morfologia") {$end = "altmor.ida2mor"; $av = "vizir.";}
    elsif ($_type eq "identificacao") {$end = "altid.ida2id"; $av = "";}

    if (length($_type) > 0) {$_type .= "/";}

    $filenamestring = $_type.$path_abs_rel.$run.".alinhado.etq.verificado.avalida.".$tot_sel.$cat_gen_var.".".$av.$end;
    #print STDOUT  "FILE: ".$filenamestring."\n";
    return $filenamestring;
}

sub getGraphName { 
    $contador++;
    return $runs."_".$curr_task."_".$contador.".jpg";
}
sub getGraphPointName {  
    $contador++;
    return $runs."_".$curr_task."_".$contador."_xy.jpg";
}
sub getGraphXYCatName {  
  $contador++;
    return $runs."_".$curr_task."_".$contador."_xycat.jpg";
}

sub nohtml {
    # retira etiquetas HTML
    $item = shift;
    $item =~ /(<.*>)?([\d|,|\.]+)(<.*>)?/;
    return $2;
}

sub fechar_tabela {
    # fecha a tabela
    return "</table>\n<BR>\n";
}

sub retirarCasasDecimais {
    # converte e formata os nmeros
    $line2= shift;
    $line2 =~ s/(\d+\.\d+)/&converter($1)/eg;
    $line2 =~ s/(\d)\./$1,/g;
    return $line2;
}
  
sub converter  {
    # arredonda os nmeros
    $num = shift;
    $x = Math::BigFloat->new($num);
    $num = $x->fround(4);# rounds to $a significant digits
    $num =~ s/\./,/g;
    if ($num =~ /NaN/) {$num = 0;}
    return  $num; 
}

sub takeOffNaN {
    # tira os Na
    $itemtocorrect = shift;
    if ($itemtocorrect =~ /NaN/) {$itemtocorrect = 0;}
    return $itemtocorrect;
}

sub getPerc {
    # Gera percentagens
    ($num,$div)=@_;
    if (($num == 0) && ($div == 0)) {$div = 1;} # avoid division by zero
    $num2 = sprintf("%.2f\%",($num/$div)*100);
    $num2 =~ s/\./,/g;
    return $num2;
}

sub interpretar_relatorio_html_sultao {
    # Ler os relatrios do Sulto
    # argumentos: 
         # cap - O que se quer discriminar ("" para nada, "categoria", "Gnero Textual", etc).
         # graph_yes_no - tipos de grficos a escrever
         # graph_title - Ttulo do grfico

    my ($cap,$graph_yes_no,$graph_title) = @_;
   my $titulo="";
   my $counter_pos;  
    my $buffer="";
    my %returner="";

    # variveis de grficos
    undef($graph);
    undef(@data);
    my $graph;
    my @data=([],[],[],[],[]);
    my @other_data=([],[],[]);   # guarda os valores dos outros sistemas, para fazer a mdia

    while($line = <IN>) {
	$line =~ s/<FONT COLOR=RED>//g;
	$line =~ s/<\/FONT>//g;
	if ($line =~ /^<tr><td>(<\w>)*(\w+)(<\/\w>)*<\/td>(<td>.+<\/td>)*<\/tr>/)  {
	    # linhas de relatrios 
	    # identificao: (nome, prec, abr, medf, errco, sobre, sub)
	    # morfologia: (nome, prec, abr, medf) e (nome, prec, abr, medf, errco, sobre, sub)
	    # semntica: (nome, prec, abr, medf) e (nome, prec, abr, medf, sobre, sub)  
	    
	    # processamento da linha
	    $run_name_found = $2; $itens = $4;
	    $itens =~ s/<td>//g;
	    $itens =~ s/<\/td>/#/g;
	    
	    @array_itens = split("#",$itens);
	    unshift(@array_itens); # o ltimo elemento  vazio.
	    @values = @array_itens;    
	    
	    $counter_pos++;
	    
	    # Estes grficos querem dados em formato [participante, prec,abr,medf]
	    if ($graph_yes_no =~ /bar|xyrun/) {
		push(@{$data[0]},ucfirst($run_name_found));
		push(@{$data[1]},&nohtml(shift(@array_itens)));
		push(@{$data[2]},&nohtml(shift(@array_itens)));
		push(@{$data[3]},(&nohtml(shift(@array_itens))*100));
		push(@{$data[4]},0); # o ltimo item serve apenas para separar as sries
		print STDOUT "DATA: ".${$data[0]}[ (scalar(@{$data[1]}) -1)]." ".${$data[1]}[ (scalar(@{$data[1]}) -1)]." ".${$data[2]}[ (scalar(@{$data[1]}) -1)]." ".${$data[3]}[ (scalar(@{$data[1]}) -1)]."\n" if $data_verbose;
		if ($run_name_found ne $runs) {
		    # para a mdia dos OUTROS participantes
		    push( @{$other_data[0]}, ${$data[1]}[ (scalar(@{$data[1]}) -1) ] );
		    push( @{$other_data[1]}, ${$data[2]}[ (scalar(@{$data[2]}) -1) ] );
		    push( @{$other_data[2]}, ${$data[3]}[ (scalar(@{$data[3]}) -1) ] );			     
		}
	    }
	    if ($run_name_found eq $runs) {
		$buffer .= &print_tr_line($cap,$caption,$counter_pos,@values);
	    }
            # Este grfico quer dados em formato [item, prec,abr,medf], de determinado participante
	    if ($graph_yes_no =~ /xycat/) {
		if ($run_name_found eq $run) {
		    push(@{$data[0]},$pretty_print{$caption});
		    push(@{$data[1]},&nohtml(shift(@array_itens)));
		    push(@{$data[2]},&nohtml(shift(@array_itens)));
		    push(@{$data[3]},(&nohtml(shift(@array_itens))*100));
		    push(@{$data[4]},0); # o ltimo item serve apenas para separar as sries
		    print STDOUT "DATA ".${$data[0]}[ (scalar(@{$data[1]}) -1)]." ".${$data[1]}[ (scalar(@{$data[1]}) -1)]." ".${$data[2]}[ (scalar(@{$data[1]}) -1)]." ".${$data[3]}[ (scalar(@{$data[1]}) -1)]."\n" if $data_verbose;
		}
	    } 
	}
	# fecho da tabela: fazer grfico e return
	 elsif ($line =~ /<\/TABLE>/i) {

	    if ($graph_yes_no =~ /bar|xyrun/) {

		# calcular as mdias
		$avg_precision =0;  $avg_recall =0;  $avg_f =0;  
		foreach $it (@{$other_data[0]}) {$avg_precision += $it;}
		foreach $it (@{$other_data[1]}) {$avg_recall += $it;}
		foreach $it (@{$other_data[2]}) {$avg_f += $it;}
		
		$avg_precision = $avg_precision / scalar(@{$other_data[0]});
		$avg_recall = $avg_recall / scalar(@{$other_data[1]});
		$avg_f = $avg_f / scalar(@{$other_data[2]});

		push(@{$data[0]},"mdia");push(@{$data[1]},$avg_precision);push(@{$data[2]},$avg_recall);
		push(@{$data[3]},$avg_f); push(@{$data[4]},0);

		##########################
		# fazer grfico	de barras
		##########################
		if ($graph_yes_no =~ /bar/) {
		    $num_itens = scalar(@{$data[0]});
		    $width = 200+40*$num_itens;
		    $graph = GD::Graph::bars->new($width,300);
		    $graph->set(text_space=>16);
		    
		    if ($num_itens > 6) {$horiz_vert=1;} else {$horiz_vert=0;} 
		    $graph->set(x_label => "Sadas",y_label =>"%",title=>$graph_title,long_ticks=>1, y_max_value=>100,
				y_tick_number=>10, y_label_skip=>1, bar_spacing=>4,shadow_depth=>2,accent_treshold=>200,
				x_labels_vertical=>$horiz_vert,transparent=>0,fgclr=>"black");
		    $graph->set_text_clr("black");
		    
		    GD::Text->font_path( "/usr/lib/X11/fonts/TTF/");
		    $graph->set_title_font(["luximr",gdMediumBoldFont],8);
		    $graph->set_x_label_font(["luximr",gdMediumBoldFont],10);
		    $graph->set_y_label_font(["luximr",gdMediumBoldFont],10);
		    $graph->set_x_axis_font(["luximr",gdMediumBoldFont],8);
		    $graph->set_y_axis_font(["luximr",gdMediumBoldFont],8);
		    
		    $graph->plot(\@data);
		    $namegraph = &getGraphName; 
		    open(GRAPH,">imagens/$namegraph") || die ("Could not open output for graph $namegraph");
		    binmode GRAPH;
		    $ext = $graph->export_format();
		    print GRAPH $graph->gd->$ext();
		    close(GRAPH);
		    print STDOUT "A criar imagem ".$namegraph.".\n" if $image_verbose;
		    $returner{"bar"}=$namegraph;
		}
		    
		########################
		# fazer grfico	de x-y 
		########################
		if ($graph_yes_no =~ /xyrun/) {
		    @data2 = @data[2,1]; # s interessa os X [2] e os Y [1]

		    $number_of_points = scalar(@{$data2[0]});
		    print STDOUT "NUMBER OF POINTS FOR XY: $number_of_points\n" if $data_verbose;
		    
		    if ($number_of_points != 0) {

			if ($type ne "variante") {
			    $graph = GD::Graph::points->new(300,300); 
			}else { 
			    $graph = GD::Graph::points->new(200,200); 
			}
			$graph->set(text_space=>16);
			$data_plot = GD::Graph::Data->new(); # criar os dados
			
			$data_plot->copy_from(\@data2);
			$values = $data_plot->copy();
			
			if ($curr_task ne "identificacao") {$graph->set(text_space=>16);}
			
			if ($type ne "variante" && $number_of_points > 2) {
			    $graph->set(x_label => "Abrangncia (%)",y_label =>"Preciso (%)",title=>$graph_title,long_ticks=>1, 
				y_max_value=>100, y_min_value=>0,  x_max_value=>100,x_min_value=>0,  x_tick_number=>10,
					y_tick_number=>10, y_label_skip=>1,show_values=>0,
					x_labels_vertical=>0,transparent=>0,fgclr=>"black");
			} else {
			    $graph->set(x_label => "Abrangncia (%)",y_label =>"Preciso (%)",title=>$graph_title,long_ticks=>1, 
					y_max_value=>100, y_min_value=>0,#  x_max_value=>100,x_min_value=>0,  x_tick_number=>10,
					y_tick_number=>10, y_label_skip=>1,show_values=>0,
					x_labels_vertical=>0,transparent=>0,fgclr=>"black");
			}
			$graph->set_text_clr("black");
			GD::Text->font_path( "/usr/lib/X11/fonts/TTF/");
			$graph->set_title_font(["luximr",gdMediumBoldFont],8);
			$graph->set_x_label_font(["luximr",gdMediumBoldFont],10);
			$graph->set_y_label_font(["luximr",gdMediumBoldFont],10);
			$graph->set_x_axis_font(["luximr",gdMediumBoldFont],8);
			$graph->set_y_axis_font(["luximr",gdMediumBoldFont],8);
			
			# H que desenhar primeiro o grfico
			$graph->plot($values);
			
			# obter as coordenadas dos pontos da 1 (e nica) srie
			@serie = $graph->get_hotspot(1);
			
			# obter a imagem, para poder desenhar nela
			$draw = $graph->gd();
			
			$cc = 0;
			$html_code_legend="<TABLE BORDER=0 cellspacing=1>\n";
			
			foreach $it (@serie) {
			    @dots = @{$it}; # retirar os valores do ponto, que esto na forma ['rect',x1,y1,x2,y2]
			    $color = $draw->colorResolve($red[$cc],$green[$cc],$blue[$cc]);
			    $draw->rectangle($dots[1],$dots[3],$dots[2],$dots[4],$color);
			    $draw->fill($dots[1]+1,$dots[3]-1,$color);
			    $html_code_legend.="<TR>\n<TD width=10 height=10 bgcolor=$color_hex[$cc]><font size=1>&nbsp;&nbsp;&nbsp;&nbsp;</font></TD><TD><font size=1>".${$data[0]}[$cc]."</font></TD>\n</TR>\n";
			    $cc++;
			}
			$html_code_legend.="</TABLE>\n";
			$returner{"xyrunlegend"}=$html_code_legend;
			$namegraph2 = &getGraphPointName;
			open(GRAPH,">imagens/$namegraph2") || die ("Could not open output for graph $namegraph2");
			binmode GRAPH;
			$ext = $graph->export_format();
			print GRAPH $draw->$ext();
			close(GRAPH);
			print STDOUT "A criar imagem ".$namegraph2.".\n" if $image_verbose;
			$returner{"namegraphxyrun"}=$namegraph2;
		    }
		}
	    } elsif ($number_of_points == 0) {
		$returner{"namegraphxyrun"} = "";
	    }
	    $returner{"buffer"} = $buffer;
	    return %returner;

	#incio da tabela
	} elsif ($line =~ /<TABLE/i) {
	    $counter_pos = 0; # contador da posio

	# ttulos da tabela
	} elsif ($line =~ /Classificao Morfolgica - (.+)<\/TH>/) {
	    $titulo = $1;
	
	# interpretados da caption da tabela
	} elsif ($line =~ /Ficheiros utilizados: \[\w+\.([^\.]+)\./) {
	    # usei o regexp assim em vez de  \[\w+\.(\w+)\./, para apanhar coisas tipo literário
	    $caption = $1;
	    $caption =~ s/á//g;
	    $caption =~ s/ó//g;
	    $caption =~ s/é//g;
	    $caption =~ s/í//g;
	} 
   }
}

sub print_tr_line {
    ($cap, $caption, $counter_pos, @values) = @_;
    $string = "<tr>";
    if (length($cap) > 0) {$string .= "<td>$pretty_print{$caption}</td>";}
    $string .= "<td>$counter_pos</td>";
    foreach $it (@values) {

	if ($it =~ /^([\d\.]+)(<\/\w+>)+$/) { 
	    # este ltimo  uma martelada que no deixava fazer o html2ps, pois os relatrios globais de morfologia 
	    # tinham tags </FONT> sem serem abertas (ex: <TD>0</b></font></TD>).
	    $it = $1; 
	}
	$string .= "<td>$it</td>";
    }
    $string .= "</tr>\n";
    return &retirarCasasDecimais($string);   
}

sub getData {
    ($Second, $Minute, $Hour, $Day, $Month, $Year, $WeekDay, $DayOfYear, $IsDST) = localtime(time) ; 
    $RealMonth = $Month + 1;
    if($RealMonth < 10) {$RealMonth = "0".$RealMonth ;}
    if($Day < 10){$Day = "0" . $Day ;}
    if($Year >= 100) {$Fixed_Year = $Year - 100 ;}else{$Fixed_Year = $Year ;} 
    $Fixed_Year = $Year + 1900; 
    return sprintf("%02d/%02d/%04d", $Day, $RealMonth, $Fixed_Year) ; 
}

sub html_header {

    print OUT "<HTML>\n<HEAD>\n<TITLE>HAREM: Relatrio individual para o sistema $sistema, sada ".ucfirst($runs)."</TITLE>\n";
#    print OUT "<META name=\"saida\" content=\"$runs\">\n";
#    print OUT "<META name=\"data\" content=\"".&getData."\">\n";
    print OUT "</HEAD>\n<BODY>\n";
    print OUT "<DIV style=\"background:#f3ea57; align:center; color: #333333;border:1px solid #979139\"><H3><center>HAREM - Avaliao de Reconhecimento de Entidades Mencionadas<BR>Relatrio individual para o sistema $sistema, sada <font color=red>".ucfirst($runs)."</font></center></H3>";
    #print OUT "<P align=CENTER><font size=2>Relatrio gerado no dia ".&getData."</font></P>";
    #print OUT "<P align=CENTER><font size=2><a href=\"http://www.linguateca.pt/HAREM/\">HAREM - http://www.linguateca.pt/HAREM/</a></font></P><BR>
    print OUT "</DIV>\n";
}

sub index {
    for ($i=1; $i<=3; $i++) { 

	if ($i == 1) {$num=1; print OUT "<ul><li><a href=\"#$num\">$chapter. Tarefa de identificao\n";}
	if ($i == 2 && arg_morf) {$num++;print OUT "<ul><li><a href=\"#$num\">$num. Tarefa de classificao morfolgica\n";}
	if ($num == 3 && arg_sem) {$num++;print OUT "<ul><li><a href=\"#$num\">$num. Tarefa de classificao semntica\n";}

	$num2=1;$num3=1;$num4=1;

	print OUT "<ul>\n<li>\n<a href=\"#$num.$num2\">$num.$num2 Resultados globais</a><br>\n";  
	if ($num1 eq 1) {
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Cenrio total</a><br>\n"; $num3++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Cenrio selectivo</a><br>\n</ul>\n"; $num3=1;
	} else {
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Forma de avaliao absoluta</a><br>\n";
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio total</a><br>\n"; $num4++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio selectivo</a><br>\n</ul>\n"; $num4=1;$num3++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Forma de avaliao relativa</a><br>\n";
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio total</a><br>\n"; $num4++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio selectivo</a><br>\n</ul>\n</ul>\n"; $num4=1; $num3=1;
	}
	$num2++;
	print OUT "<li>\n<a href=\"#$num.$num2\">$num.$num2 Resultados por categoria</a><br>\n";  
	
	if ($num1 eq 1) {
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Cenrio total</a><br>\n"; $num3++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Cenrio selectivo</a><br>\n</ul>\n"; $num3=1;
	} else {
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Forma de avaliao absoluta</a><br>\n";
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio total</a><br>\n"; $num4++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio selectivo</a><br>\n</ul>\n"; $num4=1;$num3++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Forma de avaliao relativa</a><br>\n";
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio total</a><br>\n"; $num4++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio selectivo</a><br>\n</ul>\n</ul>\n"; $num4=1; $num3=1;
	}
	
	$num2++;
	print OUT "<li>\n<a href=\"#$num.$num2\">$num.$num2 Resultados por gnero textual</a><br>\n";  
	
	if ($num1 eq 1) {
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Cenrio total</a><br>\n"; $num3++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Cenrio selectivo</a><br>\n</ul>\n"; $num3=1;
	} else {
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Forma de avaliao absoluta</a><br>\n";
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio total</a><br>\n"; $num4++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio selectivo</a><br>\n</ul>\n"; $num4=1;$num3++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Forma de avaliao relativa</a><br>\n";
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio total</a><br>\n"; $num4++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio selectivo</a><br>\n</ul>\n</ul>\n"; $num4=1; $num3=1;
	}
	
	$num2++;
	print OUT "<li>\n<a href=\"#$num.$num2\">$num.$num2 Resultados por variante</a><br>\n";  
	
	if ($num1 eq 1) {
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Cenrio total</a><br>\n"; $num3++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Cenrio selectivo</a><br>\n</ul>\n"; $num3=1;
	} else {
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Forma de avaliao absoluta</a><br>\n";
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio total</a><br>\n"; $num4++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio selectivo</a><br>\n</ul>\n"; $num4=1;$num3++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3\">$num.$num2.$num3 Forma de avaliao relativa</a><br>\n";
	    print OUT "<ul>\n<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio total</a><br>\n"; $num4++;
	    print OUT "<li>\n<a href=\"#$num.$num2.$num3.$num4\">$num.$num2.$num3.$num4 Cenrio selectivo</a><br>\n</ul>\n</ul>\n"; $num4=1; $num3=1;
	}
	print OUT "</UL>\n</ul>\n</ul>\n\n";
    }
}
sub breakpage {
    print OUT "\n<HR class=PAGE-BREAK>\n";
}

__END__


=head1 NOME
                                                                                                                                                 
alcaide.pl - Gera relatrios individuais das sadas dos participantes, a partir dos relatrios do Sulto, ida2id, ida2mor e ids2sem.
                                                                                                                                                 
=head1 SINOPSE
                                                                                                                                                 
   alcaide.pl -sistema [sistema] -run [sada] -id [0|1] -morf [0|1] -sem [0|1]
                                                                                                                                                  
=head1 DESCRICAO
                                                                                                                                                 
=head2 -sistema
                                                                                                                                                 
Nome do sistema
                                                                                                                                                 
=head2 -run
                                                                                                                                                 
Nome da sada
                                                                                                                                                 
=head2 -id
                                                                                                                                                 
Incluir relatrio da tarefa de identificao.
   
=head2 -morf
                                                                                                                                                 
Incluir relatrio da tarefa de classificao morfolgica

=head2 -sem
                                                                                                                                                 
Incluir relatrio da tarefa de classificao semntica
                                                                                                                                              
                                                                                                        
