#!/usr/bin/perl

use Getopt::Long;
use Lingua::PT::PLNbase;

my $ficheiro;
my $ficheiro2;
my $cdids;
my %hash;

my @list_ids;

my $results  = GetOptions ("in=s" => \$ficheiro,
			   "out=s" => \$ficheiro2,
			   "cdids=s"=> \$cdids);

open(IN,"<$ficheiro")||die("Erro: No foi especificado/encontrado o ficheiro de soluo.".&ajuda()."\n");
open(CDIDS,"<$cdids")||die("Erro: No foi especificado/encontrado o ficheiro de identificadores de documentos.".&ajuda()."\n");
open(OUT,">$ficheiro2")||die("Erro: No consigo escrever para o ficheiro de sada.".&ajuda()."\n");

while ($line = <CDIDS>) {
    chomp($line);
    if ($line !~ /^#/) { # retirar comentrios
	if ($line =~ /^(\d+)/) { # ignora o que vier a seguir.
	    push(@list_ids,$1);
	    $countCDids++;
	}
    }
}
print STDOUT "Li $countCDids identificadores. ";

$/="</DOC>";
while ($line = <IN>) {
    if ($line =~ /<DOCID>HAREM-\d\d.-(\d{5})<\/DOCID>/) {
	if (exists($hash{$1})) {
	    die ("H problemas com o documento de ID $1. Por favor verifique. O programa vai terminar agora.");
	} else {
	    $hash{$1} = $line;
	}
    }
}

$count=0;
foreach $key (sort {$a<=>$b} keys %hash) {
    if (&in_array($key, @list_ids)) {
	print OUT $hash{$key};
	$count++;
    }
}
print STDOUT "Escrevi no ficheiro de sada $count documentos.";

close(IN);
close(OUT);

sub in_array() {
    ($need,@haystack) = @_;    
    foreach $elem(@haystack) {
       if($need eq $elem) { return 1; }
    }
    return 0;
}

sub ajuda() {
    return "\n\nExtractor de documentos da Coleco HAREM v0.2\n".
    "Utilizao:\n".
    "perl extrairCDsdasSubmissoes.pl -in [FICHEIRO DE ENTRADA] -out [FICHEIRO DE SADA] -cdids [FICHEIRO COM IDENTIFICADORES DE DOCUMENTOS].\n";
}
